/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.profiling.AbstractProfileTest;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"profiling"})
public class ProfileTest
extends AbstractProfileTest {
    protected static final long DURATION = 300000L;
    protected static final int NUM_THREADS = 5;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 50;
    protected static final int MAX_DEPTH = 4;
    protected static final int MAX_OVERALL_NODES = 100;
    protected static final int WARMUP_LOOPS = 10000;
    private List<Fqn> fqns = new ArrayList<Fqn>(100);
    private Random r = new Random();
    private Log log = LogFactory.getLog(ProfileTest.class);

    public void testReplSync() throws Exception {
        this.runCompleteTest();
    }

    public void testReplAsync() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.runCompleteTest();
    }

    public void testReplSyncOptimistic() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    public void testReplAsyncOptimistic() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    public void testReplSyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSync();
    }

    public void testReplAsyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsync();
    }

    public void testReplSyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSyncOptimistic();
    }

    public void testReplAsyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsyncOptimistic();
    }

    private void runCompleteTest() throws Exception {
        this.init();
        this.startup();
        this.warmup();
        this.doTest();
        System.in.read();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting init() phase");
        this.fqns.clear();
        for (int i = 0; i < 100; ++i) {
            Fqn fqn = this.createRandomFqn(this.r);
            while (this.fqns.contains(fqn)) {
                fqn = this.createRandomFqn(this.r);
            }
            if (i % 10 == 0) {
                this.log.warn((Object)("Generated " + i + " fqns"));
            }
            this.fqns.add(fqn);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    private Fqn createRandomFqn(Random r) {
        String s = "/";
        int depth = r.nextInt(4);
        for (int i = 0; i < depth; ++i) {
            s = s + r.nextInt(Integer.MAX_VALUE) + "/";
        }
        return Fqn.fromString((String)s);
    }

    private void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting warmup");
        for (Fqn f : this.fqns) {
            this.cache.put(f, Collections.emptyMap());
        }
        for (int i = 0; i < 10000; ++i) {
            Fqn f;
            f = this.fqns.get(this.r.nextInt(100));
            this.cache.get(f, (Object)"");
            this.cache.put(f, (Object)"k", (Object)"v");
            this.cache.remove(f, (Object)"k");
        }
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished warmup.  " + this.printDuration(duration)));
    }

    private void doTest() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(5);
        long end = System.currentTimeMillis() + 300000L;
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting test");
        int i = 0;
        while (System.currentTimeMillis() < end) {
            exec.execute(new MyRunnable(i++));
            TestingUtil.sleepRandom(50);
        }
        this.log.warn((Object)"Finished generating runnables; awaiting executor completion");
        exec.shutdown();
        exec.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished test.  " + this.printDuration(duration)));
    }

    private String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int len = this.r.nextInt(10);
        for (int i = 0; i < len; ++i) {
            sb.append((char)(63 + this.r.nextInt(26)));
        }
        return sb.toString();
    }

    private String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    private class MyRunnable
    implements Runnable {
        int id;

        private MyRunnable(int id) {
            this.id = id;
        }

        public void run() {
            if (this.id % 100 == 0) {
                ProfileTest.this.log.warn((Object)("Processing iteration " + this.id));
            }
            String k = ProfileTest.this.getRandomString();
            String v = ProfileTest.this.getRandomString();
            ProfileTest.this.cache.put((Fqn)ProfileTest.this.fqns.get(ProfileTest.this.r.nextInt(100)), (Object)k, (Object)v);
        }
    }
}

