/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RPCManager;
import org.jboss.cache.RPCManagerImpl;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PrepareCommitContentionTest {
    CacheSPI<Object, Object> c1;
    CacheSPI<Object, Object> c2;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.c1 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.c1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.c1.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.c1.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.c2 = (CacheSPI)new DefaultCacheFactory().createCache(this.c1.getConfiguration().clone(), false);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c1, this.c2});
    }

    public void testWithSyncCommitPhase() throws Exception {
        this.doTest(true, false);
    }

    public void testWithDefautCommitPhase() throws Exception {
        this.doTest(false, false);
    }

    public void testControl() throws Exception {
        try {
            this.doTest(false, true);
            assert (false) : "Should fail if we don't use out of band messages for non-sync commits";
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private void doTest(final boolean syncCommit, boolean noOutOfBandMessages) throws Exception {
        this.c1.getConfiguration().setSyncCommitPhase(syncCommit);
        this.c2.getConfiguration().setSyncCommitPhase(syncCommit);
        final CountDownLatch mainThreadCommitLatch = new CountDownLatch(1);
        final CountDownLatch secondThreadPrepareLatch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/a/b/c");
        DelayingRPCManager delayingRPCManager = new DelayingRPCManager(mainThreadCommitLatch, secondThreadPrepareLatch, syncCommit, noOutOfBandMessages);
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(this.c1);
        cr.registerComponent(RPCManager.class.getName(), (Object)delayingRPCManager, RPCManager.class);
        this.c1.start();
        this.c2.start();
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.c1, this.c2});
        TransactionManager tm = this.c1.getTransactionManager();
        Thread secondTransaction = new Thread("SecondThread"){

            public void run() {
                try {
                    secondThreadPrepareLatch.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    TransactionManager tm = PrepareCommitContentionTest.this.c1.getTransactionManager();
                    if (syncCommit) {
                        mainThreadCommitLatch.countDown();
                    }
                    tm.begin();
                    PrepareCommitContentionTest.this.c1.put(fqn, (Object)"k", (Object)"v2");
                    tm.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        secondTransaction.start();
        tm.begin();
        this.c1.put(fqn, (Object)"k", (Object)"v");
        tm.commit();
        secondTransaction.join();
        assert (this.c1.get(fqn, (Object)"k").equals("v2"));
        assert (this.c2.get(fqn, (Object)"k").equals("v2"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DelayingRPCManager
    extends RPCManagerImpl {
        CountDownLatch mainThreadLatch;
        CountDownLatch secondThreadLatch;
        boolean syncCommit;
        boolean noOOBMessages = false;

        public DelayingRPCManager(CountDownLatch latch1, CountDownLatch latch2, boolean syncCommit, boolean noOOBMessages) {
            this.mainThreadLatch = latch1;
            this.secondThreadLatch = latch2;
            this.syncCommit = syncCommit;
            this.noOOBMessages = noOOBMessages;
        }

        public List<Object> callRemoteMethods(final List<Address> recipients, final MethodCall methodCall, final int mode, final boolean excludeSelf, final long timeout, final RspFilter responseFilter, final boolean oob) throws Exception {
            if (this.isPrepareMethod(methodCall) && Thread.currentThread().getName().equals("SecondThread")) {
                if (!this.syncCommit) {
                    this.mainThreadLatch.countDown();
                }
            } else if (this.isCommitMethod(methodCall) && !Thread.currentThread().getName().equals("SecondThread")) {
                Thread th = new Thread(){

                    public void run() {
                        try {
                            DelayingRPCManager.this.secondThreadLatch.countDown();
                            DelayingRPCManager.this.mainThreadLatch.await();
                            Thread.sleep(1000L);
                            DelayingRPCManager.super.callRemoteMethods(recipients, methodCall, mode, excludeSelf, timeout, responseFilter, !DelayingRPCManager.this.noOOBMessages && oob);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                th.start();
                if (this.syncCommit) {
                    th.join();
                }
                return Collections.emptyList();
            }
            return super.callRemoteMethods(recipients, methodCall, mode, excludeSelf, timeout, responseFilter, !this.noOOBMessages && oob);
        }

        private boolean isCommitMethod(MethodCall call) {
            return call.getMethodId() == 11 || call.getMethodId() == 13 && this.isCommitMethod((MethodCall)call.getArgs()[0]);
        }

        private boolean isPrepareMethod(MethodCall call) {
            return call.getMethodId() == 10 || call.getMethodId() == 13 && this.isPrepareMethod((MethodCall)call.getArgs()[0]);
        }
    }
}

