/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.impl;

import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.Fqn;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

/**
 * Method declarations for rollback method mostly.
 *
 * @author Ben Wang
 * @version $Revision: 3937 $
 */
public class MethodDeclarations
{
   public static final Method attachInterceptor;
   public static final Method detachInterceptor;
   public static final Method undoAttachInterceptor;
   public static final Method undoDetachInterceptor;
   ;
   public static final Method inMemorySubstitution;
   ;
   public static final Method undoInMemorySubstitution;
   ;
   public static final Method incrementReferenceCount;
   public static final Method decrementReferenceCount;
   public static final Method undoIncrementReferenceCount;
   public static final Method undoDecrementReferenceCount;

   static
   {
      try
      {
         attachInterceptor = PojoUtil.class.getDeclaredMethod("attachInterceptor",
                                                              new Class[]{Object.class, InstanceAdvisor.class, Interceptor.class});
         detachInterceptor = PojoUtil.class.getDeclaredMethod("detachInterceptor",
                                                              new Class[]{InstanceAdvisor.class, Interceptor.class});
         undoAttachInterceptor = PojoUtil.class.getDeclaredMethod("undoAttachInterceptor",
                                                                  new Class[]{Object.class, InstanceAdvisor.class, Interceptor.class});
         undoDetachInterceptor = PojoUtil.class.getDeclaredMethod("undoDetachInterceptor",
                                                                  new Class[]{InstanceAdvisor.class, Interceptor.class});
         inMemorySubstitution = PojoUtil.class.getDeclaredMethod("inMemorySubstitution",
                                                                 new Class[]{Object.class, Field.class, Object.class});
         undoInMemorySubstitution = PojoUtil.class.getDeclaredMethod("undoInMemorySubstitution",
                                                                     new Class[]{Object.class, Field.class, Object.class});
         incrementReferenceCount = PojoUtil.class.getDeclaredMethod("incrementReferenceCount",
                                                                    new Class[]{Fqn.class, int.class, List.class});
         decrementReferenceCount = PojoUtil.class.getDeclaredMethod("decrementReferenceCount",
                                                                    new Class[]{Fqn.class, int.class, List.class});
         undoIncrementReferenceCount = PojoUtil.class.getDeclaredMethod("undoIncrementReferenceCount",
                                                                        new Class[]{Fqn.class, int.class, List.class});
         undoDecrementReferenceCount = PojoUtil.class.getDeclaredMethod("undoDecrementReferenceCount",
                                                                        new Class[]{Fqn.class, int.class, List.class});
      }
      catch (NoSuchMethodException e)
      {
         throw new ExceptionInInitializerError(e);
      }
   }
}
