/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.cache.pojo.impl;

import org.jboss.cache.Fqn;

/**
 * A referrer node refers to an internal node.
 * 
 * @author Jason T. Greene
 */
final class Referrer
{
   private Fqn fqn;
   private String field;

   Referrer(Fqn fqn)
   {
      this(fqn, null);
   }
   
   Referrer(Fqn fqn, String field)
   {
      if (fqn == null)
         throw new IllegalArgumentException("Fqn can not be null!!");
      
      this.fqn = fqn;
      this.field = field;
   }

   public String getField()
   {
      return field;
   }

   public Fqn getFqn()
   {
      return fqn;
   }
   
   private boolean equals(Object o1, Object o2)
   {
      if (o1 == o2)
         return true;
      
      if (o1 != null && o1.equals(o2))
         return true;
      
      return false;
   }
   
   public int hashCode()
   {
      int result = 629 * fqn.hashCode();

      if (field != null)
         result = 37 * result + field.hashCode();
      
      return result;
   }
   
   public boolean equals(Object o)
   {
      if (o instanceof Referrer)
         return equals(((Referrer)o).fqn, fqn) && equals(((Referrer)o).field, field);
      
      return false;
   }
}