/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.interceptors;

import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Handles the POJO event notification.
 *
 * @author Ben Wang
 * @version $Id: PojoEventInterceptor.java 3892 2007-05-23 10:28:59Z msurtani $
 */
public class PojoEventInterceptor extends AbstractInterceptor
{
   public Object invoke(Invocation in) throws Throwable
   {
      if (!(in instanceof MethodInvocation))
      {
         throw new IllegalArgumentException("PojoEventInterceptor.invoke(): invocation not MethodInvocation");
      }
      MethodInvocation invocation = (MethodInvocation) in;
      try
      {
         System.out.println("**** Entering method: **** " + invocation.getMethod());
         return invocation.invokeNext(); // proceed to next advice or actual call
      }
      finally
      {
         System.out.println("Leaving method: " + invocation.getMethod());
      }
   }
}
