/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class TreeNodeTest {
    CacheSPI<Object, Object> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
        this.cache.destroy();
    }

    public void testChildExist() throws Exception {
        Integer key = 1;
        this.cache.put(Fqn.fromString((String)"/a/b/c"), (Object)key, (Object)"test");
        NodeSPI node = this.cache.getNode(Fqn.fromString((String)"/a/b"));
        AssertJUnit.assertFalse((boolean)node.getChildren().isEmpty());
        AssertJUnit.assertTrue((node.getChild(new Fqn((Object[])new String[]{"c"})) != null ? 1 : 0) != 0);
        Fqn fqn = Fqn.fromString((String)"/e/f");
        this.cache.put(fqn, (Object)"1", (Object)"1");
        node = this.cache.getNode(Fqn.fromString((String)"/e"));
        AssertJUnit.assertFalse((boolean)node.getChildren().isEmpty());
        AssertJUnit.assertTrue((node.getChild(new Fqn((Object[])new String[]{"f"})) != null ? 1 : 0) != 0);
    }
}

