/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.ElementSizeAlgorithm;
import org.jboss.cache.eviction.ElementSizeConfiguration;
import org.jboss.cache.eviction.ElementSizeQueue;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ElementSizeAlgorithmTest {
    RegionManager regionManager;
    ElementSizeAlgorithm algo;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algo = new ElementSizeAlgorithm();
        this.regionManager = new RegionManager();
        ElementSizeConfiguration config = new ElementSizeConfiguration();
        config.setMaxElementsPerNode(0);
        config.setEvictionPolicyClass(DummyEvictionPolicy.class.getName());
        this.regionManager.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)config);
    }

    public void testMaxElements() throws Exception {
        Region region = this.regionManager.getRegion("/a/b", true);
        ElementSizeConfiguration config = (ElementSizeConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(10);
        config.setMaxElementsPerNode(6);
        for (int i = 0; i < 10; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
            if (i % 2 != 0) continue;
            for (int k = 0; k < i; ++k) {
                region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_ELEMENT_EVENT));
            }
        }
        this.algo.process(region);
        ElementSizeQueue queue = (ElementSizeQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)9, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertEquals((int)12, (int)this.algo.getEvictionQueue().getNumberOfElements());
        Iterator it = queue.iterate();
        int count = 6;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            System.out.println(ne);
            if (count > 0) {
                AssertJUnit.assertEquals((int)count, (int)ne.getNumberOfElements());
            } else {
                AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
            }
            count -= 2;
        }
        for (int i = 0; i < 7; ++i) {
            region.putNodeEvent(new EvictedEventNode(Fqn.fromString((String)"/a/b/9"), NodeEventType.ADD_ELEMENT_EVENT));
            region.putNodeEvent(new EvictedEventNode(Fqn.fromString((String)"/a/b/7"), NodeEventType.ADD_ELEMENT_EVENT));
        }
        this.algo.process(region);
        AssertJUnit.assertEquals((int)7, (int)queue.getNumberOfNodes());
    }

    public void testMaxNodesAndMaxElements() throws Exception {
        Region region = this.regionManager.getRegion("/a/b", true);
        ElementSizeConfiguration config = (ElementSizeConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(10);
        config.setMaxElementsPerNode(100);
        for (int i = 0; i < 20; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
            for (int k = 0; k < i; ++k) {
                region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_ELEMENT_EVENT));
            }
        }
        this.algo.process(region);
        ElementSizeQueue queue = (ElementSizeQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertEquals((int)45, (int)this.algo.getEvictionQueue().getNumberOfElements());
        Iterator it = queue.iterate();
        int num = 9;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            AssertJUnit.assertEquals((int)num, (int)ne.getNumberOfElements());
            --num;
        }
    }
}

