/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.LFUAlgorithm;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.NodeEventType;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LFUAlgorithmTest {
    RegionManager regionManager;
    LFUAlgorithm algo;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algo = new LFUAlgorithm();
        LFUConfiguration config = new LFUConfiguration();
        this.regionManager = new RegionManager();
        config.setEvictionPolicyClass(DummyEvictionPolicy.class.getName());
        this.regionManager.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)config);
    }

    public void testMaxNode1() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = new LFUConfiguration();
        config.setMaxNodes(0);
        config.setMinNodes(20);
        region.setEvictionPolicy((EvictionPolicyConfig)config);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        try {
            this.algo.process(region);
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode2() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = new LFUConfiguration();
        config.setMaxNodes(1);
        config.setMinNodes(20);
        region.setEvictionPolicy((EvictionPolicyConfig)config);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        try {
            this.algo.process(region);
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        try {
            this.algo.process(region);
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMinNode1() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/c/d/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/c/d/e/f");
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = (LFUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setMinNodes(2);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.ADD_NODE_EVENT));
        this.algo.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMinNode2() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = (LFUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setMinNodes(0);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        this.algo.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)0, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testEvictionQueueSortOrder1() throws Exception {
        NodeEntry ne;
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/c/d/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/c/d/e/f");
        Fqn fqn5 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h");
        Fqn fqn6 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i");
        Fqn fqn7 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j");
        Fqn fqn8 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k");
        Fqn fqn9 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k/l");
        Fqn fqn10 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k/l/m");
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = (LFUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setMinNodes(100);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn5, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn6, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn7, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn8, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn9, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn10, NodeEventType.ADD_NODE_EVENT));
        this.algo.process(region);
        LFUQueue queue = (LFUQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        Iterator it = queue.iterate();
        while (it.hasNext()) {
            NodeEntry ne2 = (NodeEntry)it.next();
            System.out.println("Fqn: " + ne2.getFqn() + " NodeVisits: " + ne2.getNumberOfNodeVisits());
            AssertJUnit.assertEquals((int)1, (int)ne2.getNumberOfNodeVisits());
        }
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn9, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn10, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn10, NodeEventType.VISIT_NODE_EVENT));
        this.algo.process(region);
        System.out.println();
        System.out.println();
        it = queue.iterate();
        int count = 0;
        while (it.hasNext()) {
            NodeEntry ne3 = (NodeEntry)it.next();
            System.out.println("Fqn: " + ne3.getFqn() + " NodeVisits: " + ne3.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne3.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)3, (int)ne3.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9) {
                AssertJUnit.assertEquals((int)4, (int)ne3.getNumberOfNodeVisits());
                continue;
            }
            if (count == 10) {
                AssertJUnit.assertEquals((int)5, (int)ne3.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne3.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        Fqn fqn11 = Fqn.fromString((String)"/a");
        Fqn fqn12 = Fqn.fromString((String)"/a/b");
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn12, NodeEventType.ADD_NODE_EVENT));
        this.algo.process(region);
        System.out.println();
        System.out.println();
        it = queue.iterate();
        count = 0;
        while (it.hasNext()) {
            ne = (NodeEntry)it.next();
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9 || count == 10) {
                AssertJUnit.assertEquals((int)3, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 11) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 12) {
                AssertJUnit.assertEquals((int)5, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)12, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.REMOVE_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.REMOVE_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn12, NodeEventType.REMOVE_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn10, NodeEventType.REMOVE_NODE_EVENT));
        this.algo.process(region);
        System.out.println();
        System.out.println();
        it = queue.iterate();
        count = 0;
        while (it.hasNext()) {
            ne = (NodeEntry)it.next();
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7) {
                AssertJUnit.assertEquals((int)3, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 8) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)8, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn11, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.VISIT_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.REMOVE_NODE_EVENT));
        this.algo.process(region);
        System.out.println();
        System.out.println();
        it = queue.iterate();
        count = 0;
        while (it.hasNext()) {
            ne = (NodeEntry)it.next();
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9) {
                AssertJUnit.assertEquals((int)6, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)9, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testEvictionQueueSortOrder2() throws Exception {
        Region region = this.regionManager.getRegion("/a/b", true);
        LFUConfiguration config = (LFUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setMinNodes(10000);
        for (int i = 0; i < 10000; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        this.algo.process(region);
        LFUQueue queue = (LFUQueue)this.algo.evictionQueue;
        Iterator it = queue.iterate();
        long lastModifiedTimestamp = 0L;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            AssertJUnit.assertTrue((lastModifiedTimestamp <= ne.getModifiedTimeStamp() ? 1 : 0) != 0);
            lastModifiedTimestamp = ne.getModifiedTimeStamp();
        }
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 != 0) continue;
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT));
        }
        this.algo.process(region);
        it = queue.iterate();
        int count = 0;
        lastModifiedTimestamp = 0L;
        while (it.hasNext()) {
            NodeEntry ne = (NodeEntry)it.next();
            AssertJUnit.assertTrue((lastModifiedTimestamp <= ne.getModifiedTimeStamp() ? 1 : 0) != 0);
            lastModifiedTimestamp = ne.getModifiedTimeStamp();
            if (count < 5000) {
                AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
            } else {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
            }
            ++count;
        }
        AssertJUnit.assertEquals((int)10000, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }
}

