/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.DummyEvictionConfiguration;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUPolicy;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class RegionManagerTest {
    private final Fqn DEFAULT_REGION = Fqn.ROOT;
    Fqn A_B_C = Fqn.fromString((String)"/a/b/c");
    Fqn A_B = Fqn.fromString((String)"/a/b");
    Fqn A_BC = Fqn.fromString((String)"/a/bc");
    Fqn AOP = Fqn.fromString((String)"/aop");
    EvictionPolicy policy;
    EvictionPolicyConfig config;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.policy = new DummyEvictionPolicy();
        this.config = new DummyEvictionConfiguration();
    }

    public void testCreateRegion() {
        RegionManager regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_B_C, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.AOP, true).setEvictionPolicy(this.config);
        List regions = regionManager.getAllRegions(Region.Type.ANY);
        AssertJUnit.assertEquals((String)"Region size ", (int)4, (int)regions.size());
    }

    public void testCreateRegion2() {
        RegionManager regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.A_B_C, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionPolicy(this.config);
        List regions = regionManager.getAllRegions(Region.Type.ANY);
        AssertJUnit.assertEquals((String)"Region size ", (int)3, (int)regions.size());
        AssertJUnit.assertEquals((String)"Region 0", (Object)this.DEFAULT_REGION, (Object)((Region)regions.get(0)).getFqn());
        AssertJUnit.assertEquals((String)"Region 1 ", (Object)this.A_B, (Object)((Region)regions.get(1)).getFqn());
        AssertJUnit.assertEquals((String)"Region 2 ", (Object)this.A_B_C, (Object)((Region)regions.get(2)).getFqn());
        Region region = regionManager.getRegion("/a/b/c/d", false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.A_B_C, (Object)region.getFqn());
        region = regionManager.getRegion(this.A_B, false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.A_B, (Object)region.getFqn());
        region = regionManager.getRegion("/a", false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.DEFAULT_REGION, (Object)region.getFqn());
    }

    public void testNoDefaultRegion() {
        RegionManager regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.A_B_C, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionPolicy(this.config);
        try {
            regionManager.getRegion(Fqn.fromString((String)"/a"), Region.Type.EVICTION, false);
            AssertJUnit.fail((String)"If we don't setCache the default region, we should throw a RTE!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetRegion() {
        RegionManager regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_BC, true).setEvictionPolicy(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionPolicy(this.config);
        Region region = regionManager.getRegion(this.A_BC, true);
        AssertJUnit.assertNotSame((String)"Region ", (Object)this.DEFAULT_REGION, (Object)region.getFqn());
    }

    public void testConfigureWithXML() throws Exception {
        String xml = "<region name=\"/test/\" policyClass=\"org.jboss.cache.eviction.LFUPolicy\"><attribute name=\"minNodes\">10</attribute><attribute name=\"maxNodes\">20</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        RegionManager regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        EvictionRegionConfig erc = XmlConfigurationParser.parseEvictionRegionConfig((Element)element, null, (int)200000);
        Region region = regionManager.getRegion(erc.getRegionFqn(), true);
        region.setEvictionPolicy(erc.getEvictionPolicyConfig());
        AssertJUnit.assertTrue((boolean)(region.getEvictionPolicy() instanceof LFUPolicy));
        AssertJUnit.assertTrue((boolean)(region.getEvictionPolicyConfig() instanceof LFUConfiguration));
        LFUConfiguration config = (LFUConfiguration)region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((int)20, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((int)10, (int)config.getMinNodes());
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test/"), (Object)region.getFqn());
        xml = "<region name=\"abc\"><attribute name=\"minNodes\">10</attribute><attribute name=\"maxNodes\">20</attribute></region>";
        element = XmlHelper.stringToElement((String)xml);
        erc = XmlConfigurationParser.parseEvictionRegionConfig((Element)element, (String)"org.jboss.cache.eviction.LFUPolicy", (int)200000);
        regionManager = new RegionManager();
        regionManager.setUsingEvictions(true);
        region = regionManager.getRegion(erc.getRegionFqn(), true);
        region.setEvictionPolicy(erc.getEvictionPolicyConfig());
        AssertJUnit.assertTrue((boolean)(region.getEvictionPolicy() instanceof LFUPolicy));
        AssertJUnit.assertTrue((boolean)(region.getEvictionPolicyConfig() instanceof LFUConfiguration));
        config = (LFUConfiguration)region.getEvictionPolicyConfig();
        AssertJUnit.assertEquals((int)20, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((int)10, (int)config.getMinNodes());
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/abc/"), (Object)region.getFqn());
    }

    public void testRegionOrdering() throws Exception {
        Fqn A_B_C_D_E = Fqn.fromString((String)"/a/b/c/d/e/");
        Fqn A_B_C_D = Fqn.fromString((String)"/a/b/c/d/");
        RegionManager rm = new RegionManager();
        rm.setUsingEvictions(true);
        rm.getRegion(this.DEFAULT_REGION, true).setEvictionPolicy(this.config);
        rm.getRegion(A_B_C_D_E, true).setEvictionPolicy(this.config);
        rm.getRegion(A_B_C_D, true).setEvictionPolicy(this.config);
        rm.getRegion(this.A_B_C, true).setEvictionPolicy(this.config);
        Region region = rm.getRegion("/a/b/c/d/e/f", false);
        Region region2 = rm.getRegion("/e/f/g", false);
        AssertJUnit.assertEquals((Object)A_B_C_D_E, (Object)region.getFqn());
        AssertJUnit.assertEquals((Object)this.DEFAULT_REGION, (Object)region2.getFqn());
        List regions = rm.getAllRegions(Region.Type.ANY);
        block6: for (int i = 0; i < regions.size(); ++i) {
            switch (i) {
                case 0: {
                    AssertJUnit.assertEquals((Object)this.DEFAULT_REGION, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 1: {
                    AssertJUnit.assertEquals((Object)this.A_B_C, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 2: {
                    AssertJUnit.assertEquals((Object)A_B_C_D, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 3: {
                    AssertJUnit.assertEquals((Object)A_B_C_D_E, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                default: {
                    AssertJUnit.fail((String)"This error condition should never be reached");
                }
            }
        }
    }
}

