/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReplicatedLRUPolicyTest {
    CacheSPI<Object, Object> cache_;
    CacheSPI<Object, Object> cache1_;
    CacheSPI<Object, Object> cache2_;
    int wakeupIntervalMillis_ = 0;
    EvictionListener listener_ = new EvictionListener();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache_ = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true), false);
        this.cache_.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache_.start();
        this.cache_.getNotifier().addCacheListener((Object)this.listener_);
        this.listener_.resetCounter();
        this.cache2_ = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache2_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2_.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache2_.start();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ <= 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
        this.cache2_.stop();
    }

    public void testBasic() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        String str = rootStr + "0";
        this.cache_.put(str, (Object)str, (Object)str);
        TestingUtil.sleepThread(30000L);
        NodeSPI node = this.cache_.peek(Fqn.fromString((String)str), false);
        AssertJUnit.assertNull((String)"DataNode should be evicted already ", (Object)node);
        AssertJUnit.assertEquals((String)"Eviction counter ", (int)1, (int)this.listener_.getCounter());
        String val = (String)this.cache2_.get(str, (Object)str);
        AssertJUnit.assertNotNull((String)"DataNode should not be evicted here ", (Object)val);
        AssertJUnit.assertEquals((String)"Eviction counter ", (int)1, (int)this.listener_.getCounter());
    }

    public void testEviction() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache_.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_);
        String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be evicted already ", (Object)val);
        val = (String)this.cache2_.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNotNull((String)"DataNode should not be evicted here ", (Object)val);
    }

    public void testEvictionReplication() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache_.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ - 1000);
        String str = rootStr + "7";
        Fqn fqn = Fqn.fromString((String)str);
        this.cache_.get(fqn, (Object)str);
        TestingUtil.sleepThread(this.wakeupIntervalMillis_);
        String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        val = (String)this.cache2_.get(rootStr + "7", (Object)(rootStr + "7"));
        AssertJUnit.assertNotNull((String)"DataNode should not be null", (Object)val);
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class EvictionListener {
        int counter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
        }

        @NodeEvicted
        public void nodeEvicted(Event e) {
            System.out.println(e);
            if (e.isPre()) {
                ++this.counter;
            }
        }
    }
}

