/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.ComponentName;
import org.jboss.cache.factories.annotations.Inject;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ComponentRegistryUnitTest {
    ComponentRegistry cr;
    Configuration cfg;

    @BeforeMethod
    public void setUp() {
        this.cr = new ComponentRegistry(new Configuration());
        this.cfg = this.cr.getConfiguration();
    }

    public void testChangingComponentState() {
        this.cr.registerComponent("c2", (Object)new C2(), C2.class);
        this.cr.registerComponent("c1", (Object)new C1(), C1.class);
        this.cr.registerComponent("c3", (Object)new C3(), C3.class);
        ComponentRegistry.Component c1 = (ComponentRegistry.Component)this.cr.componentLookup.get("c1");
        ComponentRegistry.Component c2 = (ComponentRegistry.Component)this.cr.componentLookup.get("c2");
        ComponentRegistry.Component c3 = (ComponentRegistry.Component)this.cr.componentLookup.get("c3");
        ComponentRegistry componentRegistry = this.cr;
        componentRegistry.getClass();
        ComponentRegistry.Component d1 = new ComponentRegistry.Component(componentRegistry, "c1", null);
        ComponentRegistry componentRegistry2 = this.cr;
        componentRegistry2.getClass();
        ComponentRegistry.Component d2 = new ComponentRegistry.Component(componentRegistry2, "c2", null);
        ComponentRegistry componentRegistry3 = this.cr;
        componentRegistry3.getClass();
        ComponentRegistry.Component d3 = new ComponentRegistry.Component(componentRegistry3, "c3", null);
        assert (c2.dependencies.isEmpty());
        assert (c1.dependencies.contains(d2));
        assert (c1.dependencies.size() == 1);
        assert (c3.dependencies.contains(d1));
        assert (c3.dependencies.size() == 1);
        assert (c2.dependencyFor.contains(d1));
        assert (c2.dependencyFor.size() == 1);
        assert (c1.dependencyFor.contains(d3));
        assert (c1.dependencyFor.size() == 1);
        assert (c3.dependencyFor.isEmpty());
        assert (c1.state == ComponentRegistry.State.CONSTRUCTED);
        assert (c2.state == ComponentRegistry.State.CONSTRUCTED);
        assert (c3.state == ComponentRegistry.State.CONSTRUCTED);
        c1.changeState(ComponentRegistry.State.WIRED);
        assert (c1.state == ComponentRegistry.State.WIRED);
        assert (c2.state == ComponentRegistry.State.WIRED);
        assert (c3.state == ComponentRegistry.State.CONSTRUCTED);
        c3.changeState(ComponentRegistry.State.STARTED);
        assert (c1.state == ComponentRegistry.State.STARTED);
        assert (c2.state == ComponentRegistry.State.STARTED);
        assert (c3.state == ComponentRegistry.State.STARTED);
        c1.changeState(ComponentRegistry.State.CONSTRUCTED);
        assert (c1.state == ComponentRegistry.State.CONSTRUCTED);
        assert (c2.state == ComponentRegistry.State.STARTED);
        assert (c3.state == ComponentRegistry.State.CONSTRUCTED);
    }

    public static class C3 {
        C1 c1;

        @Inject
        private void inject(@ComponentName(value="c1") C1 c1) {
            this.c1 = c1;
        }
    }

    public static class C2 {
    }

    public static class C1 {
        C2 c2;

        @Inject
        private void inject(@ComponentName(value="c2") C2 c2) {
            this.c2 = c2;
        }
    }
}

