/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.ReadOnlyDelegatingCacheLoader;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class CacheLoaderTestsBase
extends AbstractCacheLoaderTestBase {
    private static final Log log = LogFactory.getLog(CacheLoaderTestsBase.class);
    CacheSPI<Object, Object> cache;
    CacheLoader loader = null;
    static final Fqn<String> FQN = new Fqn((Object[])new String[]{"key"});
    private static final Fqn<String> SUBTREE_FQN = new Fqn(FQN, (Object[])new String[]{"subtree"});
    private static final Fqn<String> BUDDY_BASE = new Fqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{"test"});
    private static final Fqn<String> BUDDY_PLUS_FQN = new Fqn(BUDDY_BASE, FQN);
    private static final Fqn<String> BUDDY_PLUS_SUBTREE_FQN = new Fqn(BUDDY_BASE, SUBTREE_FQN);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = this.cache.getConfiguration();
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.configureCache();
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
        this.postConfigure();
    }

    protected void postConfigure() {
    }

    protected abstract void configureCache() throws Exception;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        log.warn((Object)"********* Starting tearDown()");
        this.cleanup();
        try {
            this.cache.removeNode(Fqn.ROOT);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loader.remove(Fqn.ROOT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache.stop();
        this.cache.destroy();
    }

    protected void cleanup() {
    }

    protected void addDelay() {
    }

    protected boolean exists(String fqn, String key) {
        NodeSPI n = this.cache.peek(Fqn.fromString((String)fqn), false, false);
        if (key == null) {
            return n != null;
        }
        return n != null && n.getKeysDirect().contains(key);
    }

    public void testPrint() throws CacheException {
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        this.cache.put(NODE, (Object)"key", (Object)10);
        this.cache.evict(NODE, false);
        this.addDelay();
        NodeSPI ret = this.cache.getNode(NODE);
        AssertJUnit.assertNotNull((Object)ret);
    }

    public void testPut() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        this.cache.removeNode("/test");
        this.addDelay();
        Object retval = this.cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertEquals(null, (Object)retval);
        retval = this.cache.put("/test", (Object)"key", (Object)20);
        this.addDelay();
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.cache.evict(Fqn.fromString((String)"/test"), false);
        this.addDelay();
        log.debug((Object)"put 30, expect 20 back");
        retval = this.cache.put("/test", (Object)"key", (Object)30);
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut2() throws Exception {
        String NODE = "/a/b/c";
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/a/b/c")));
        String KEY = "key";
        this.cache.removeNode("/a/b/c");
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/a/b/c")));
        this.addDelay();
        Object retval = this.cache.put("/a/b/c", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = this.cache.put("/a/b/c", (Object)"key", (Object)20);
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        this.cache.evict(Fqn.fromString((String)"/a/b"), false);
        this.cache.evict(Fqn.fromString((String)"/a"), false);
        this.addDelay();
        log.debug((Object)"replace KEY with 30, expect 20");
        retval = this.cache.put("/a/b/c", (Object)"key", (Object)30);
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut3() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/a/b/c");
        this.cache.removeNode(NODE);
        this.addDelay();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        m.put("c", "d");
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("e", "f");
        m2.put("g", "h");
        this.cache.put(NODE, m);
        this.addDelay();
        this.cache.get(NODE, (Object)"X");
        AssertJUnit.assertEquals(m, (Object)this.loader.get(NODE));
        AssertJUnit.assertEquals(m, (Object)this.cache.getNode(NODE).getData());
        this.cache.evict(NODE, false);
        this.addDelay();
        this.cache.get(NODE, (Object)"X");
        AssertJUnit.assertEquals(m, (Object)this.cache.getNode(NODE).getData());
        this.cache.evict(NODE, false);
        this.cache.get(NODE, (Object)"X");
        this.cache.put(NODE, m2);
        AssertJUnit.assertEquals((String)"combined", (int)4, (int)this.cache.getNode(NODE).getData().size());
    }

    public void testShallowMove() throws Exception {
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/b");
        Fqn a_b = Fqn.fromString((String)"/a/b");
        String key = "key";
        String valueA = "A";
        String valueB = "B";
        this.cache.put(a, (Object)key, (Object)valueA);
        this.cache.put(b, (Object)key, (Object)valueB);
        this.addDelay();
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)valueA, loader.get(a).get(key));
        AssertJUnit.assertEquals((Object)valueB, loader.get(b).get(key));
        AssertJUnit.assertTrue((boolean)loader.getChildrenNames(Fqn.ROOT).contains("a"));
        AssertJUnit.assertTrue((boolean)loader.getChildrenNames(Fqn.ROOT).contains("b"));
        this.cache.move(b, a);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, loader.get(a).get(key));
        AssertJUnit.assertNull((Object)loader.get(b));
        AssertJUnit.assertEquals((Object)valueB, loader.get(a_b).get(key));
    }

    public void testDeepMove() throws Exception {
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/b");
        Fqn a_b = Fqn.fromString((String)"/a/b");
        Fqn b_c = Fqn.fromString((String)"/b/c");
        Fqn a_b_c = Fqn.fromString((String)"/a/b/c");
        String key = "key";
        String valueA = "A";
        String valueB = "B";
        String valueC = "C";
        this.cache.put(a, (Object)key, (Object)valueA);
        this.cache.put(b, (Object)key, (Object)valueB);
        this.cache.put(b_c, (Object)key, (Object)valueC);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, this.cache.getCacheLoaderManager().getCacheLoader().get(a).get(key));
        AssertJUnit.assertEquals((Object)valueB, this.cache.getCacheLoaderManager().getCacheLoader().get(b).get(key));
        AssertJUnit.assertEquals((Object)valueC, this.cache.getCacheLoaderManager().getCacheLoader().get(b_c).get(key));
        this.cache.move(b, a);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, this.cache.getCacheLoaderManager().getCacheLoader().get(a).get(key));
        AssertJUnit.assertNull((Object)this.cache.getCacheLoaderManager().getCacheLoader().get(b));
        AssertJUnit.assertEquals((Object)valueB, this.cache.getCacheLoaderManager().getCacheLoader().get(a_b).get(key));
        AssertJUnit.assertNull((Object)this.cache.getCacheLoaderManager().getCacheLoader().get(b_c));
        AssertJUnit.assertEquals((Object)valueC, this.cache.getCacheLoaderManager().getCacheLoader().get(a_b_c).get(key));
    }

    public void testPutRemoveCombos() throws Exception {
        String NODE = "/a/b/c";
        this.cache.removeNode("/a/b/c");
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        this.addDelay();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        m.put("c", "d");
        this.loader.put(fqn, m);
        this.cache.put("/a/b/c", (Object)"e", (Object)"f");
        this.addDelay();
        this.cache.get("/a/b/c", (Object)"X");
        AssertJUnit.assertEquals((int)3, (int)this.cache.getNode("/a/b/c").getData().size());
        this.cache.evict(fqn, false);
        this.cache.get("/a/b/c", (Object)"X");
        this.cache.remove("/a/b/c", (Object)"e");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNode("/a/b/c").getData().size());
    }

    public void testGet() throws CacheException {
        String NODE = "/a/b/c";
        this.cache.removeNode("/a/b/c");
        this.addDelay();
        Object retval = this.cache.put("/a/b/c", (Object)"1", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        this.cache.put("/a/b/c", (Object)"2", (Object)20);
        this.cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        AssertJUnit.assertNull((String)"DataNode should not exisit ", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), false, false));
        this.addDelay();
        retval = this.cache.get("/a/b/c", (Object)"1");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        retval = this.cache.get("/a/b/c", (Object)"2");
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testGetNode() throws CacheException {
        String NODE = "/a/b/c";
        this.cache.removeNode("/a/b/c");
        this.addDelay();
        this.cache.put("/a/b/c", (Object)"1", (Object)10);
        this.cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        AssertJUnit.assertNull((String)"DataNode should not exisit ", (Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), false, false));
        this.addDelay();
        NodeSPI retval = this.cache.getNode("/a/b/c");
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)retval);
        Node node = (Node)retval;
        AssertJUnit.assertEquals((Object)10, (Object)node.get((Object)"1"));
    }

    public void testSerialization() throws CacheException {
        SamplePojo pojo = new SamplePojo(39, "Bela");
        pojo.getHobbies().add("Running");
        pojo.getHobbies().add("Beerathlon");
        pojo.getHobbies().add("Triathlon");
        this.cache.put("/mypojo", (Object)322649, (Object)pojo);
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.cache.get("/mypojo", (Object)322649));
        this.cache.evict(Fqn.fromString((String)"/mypojo"), false);
        AssertJUnit.assertNull((Object)this.cache.peek(Fqn.fromString((String)"/mypojo"), false, false));
        SamplePojo pojo2 = (SamplePojo)this.cache.get("/mypojo", (Object)322649);
        AssertJUnit.assertNotNull((Object)pojo2);
        AssertJUnit.assertEquals((int)39, (int)pojo2.getAge());
        AssertJUnit.assertEquals((String)"Bela", (String)pojo2.getName());
        AssertJUnit.assertEquals((int)3, (int)pojo2.getHobbies().size());
    }

    public void testPopulate() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < 10; ++i) {
                m.put("key" + i, "val" + i);
            }
            this.cache.put("/a/b/c", m);
            this.cache.getCacheLoaderManager().preload(Fqn.fromString((String)"/1/2/3/4/5"), true, true);
            this.cache.put("/1/2/3/4/5", null);
            this.cache.put("/1/2/3/4/5/a", null);
            this.cache.put("/1/2/3/4/5/b", null);
            this.cache.put("/1/2/3/4/5/c", null);
            this.cache.put("/1/2/3/4/5/d", null);
            this.cache.put("/1/2/3/4/5/e", null);
            this.cache.put("/1/2/3/4/5/d/one", null);
            this.cache.put("/1/2/3/4/5/d/two", null);
            this.cache.put("/1/2/3/4/5/d/three", null);
            System.out.println("cache: " + this.cache);
            AssertJUnit.assertTrue((boolean)this.cache.exists("/1/2/3/4"));
            AssertJUnit.assertTrue((boolean)this.cache.exists("/a/b/c"));
            assert (!this.exists("/a/b/c/d", null));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testPreloading() throws CacheException {
        this.cache.removeNode(Fqn.ROOT);
        this.cache.put("1/2/3/4/5/d", (Object)"key", (Object)"val");
        this.cache.evict(Fqn.fromString((String)"1/2/3/4/5/d"));
        System.out.println("-- checking for 1/2/3/4/5/d");
        this.addDelay();
        assert (!this.exists("1/2/3/4/5/d", null));
        this.cache.getNode("1/2/3/4/5/d");
        AssertJUnit.assertTrue((boolean)this.cache.exists("1/2/3/4/5/d"));
        System.out.println("-- 1/2/3/4/5/d exists");
    }

    public void testCacheLoading2() throws Exception {
        Set keys = null;
        this.cache.put("/a/b/c", (Object)"key", (Object)"val");
        keys = this.cache.getNode("/a/b/c").getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
    }

    public void testExists() {
        this.cache.put("/eins/zwei/drei", (Object)"key1", (Object)"val1");
        AssertJUnit.assertTrue((boolean)this.cache.exists("/eins/zwei/drei"));
        assert (this.exists("/eins/zwei/drei", "key1"));
        assert (!this.exists("/eins/zwei/drei", "key2"));
        assert (!this.exists("/uno/due/tre", null));
        assert (!this.exists("/une/due/tre", "key1"));
    }

    public void testGetChildren() {
        try {
            this.cache.put("/1/2/3/4/5/d/one", null);
            this.cache.put("/1/2/3/4/5/d/two", null);
            this.cache.put("/1/2/3/4/5/d/three", null);
            Set children = this.cache.getNode("/1/2/3/4/5/d").getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("one"));
            AssertJUnit.assertTrue((boolean)children.contains("two"));
            AssertJUnit.assertTrue((boolean)children.contains("three"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildrenWithEviction() throws CacheException {
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/b/c/1"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c/2"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c/3"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c"));
        this.cache.evict(Fqn.fromString((String)"/a/b"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.cache.evict(Fqn.fromString((String)"/"));
        this.addDelay();
        Set children = this.cache.getNode("/a/b/c").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
    }

    public void testGetChildren2() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren3() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren4() {
        try {
            if (!this.cache.exists("/a/b/c")) {
                this.cache.put("/a/b/c", null);
            }
            Set children = this.cache.getChildrenNames((Fqn)null);
            AssertJUnit.assertTrue((boolean)children.isEmpty());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren5() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            NodeSPI n = this.cache.getNode("/a");
            AssertJUnit.assertNotNull((Object)n);
            Set children = n.getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren6() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            this.cache.evict(Fqn.fromString((String)"/a/1"));
            this.cache.evict(Fqn.fromString((String)"/a/2"));
            this.cache.evict(Fqn.fromString((String)"/a/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNotNull((Object)this.cache.getNode("/a"));
            Set children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren7() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            this.cache.put("/a", (Object)"test", (Object)"test");
            this.cache.evict(Fqn.fromString((String)"/a/1"));
            this.cache.evict(Fqn.fromString((String)"/a/2"));
            this.cache.evict(Fqn.fromString((String)"/a/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            Object val = this.cache.get("/a", (Object)"test");
            AssertJUnit.assertEquals((String)"attributes weren't loaded", (Object)"test", (Object)val);
            Set children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren8() {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        this.cache.getNode("/a/1");
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
    }

    public void testGetChildren9() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            this.cache.evict(Fqn.fromString((String)"/a/1"));
            this.cache.evict(Fqn.fromString((String)"/a/2"));
            this.cache.evict(Fqn.fromString((String)"/a/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
            this.cache.getNode("/a/1");
            Set children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
            this.cache.evict(Fqn.fromString((String)"/a/1"));
            this.cache.evict(Fqn.fromString((String)"/a/2"));
            this.cache.evict(Fqn.fromString((String)"/a/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
            this.cache.getNode("/a/1");
            children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren10() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            this.cache.evict(Fqn.fromString((String)"/a/1"));
            this.cache.evict(Fqn.fromString((String)"/a/2"));
            this.cache.evict(Fqn.fromString((String)"/a/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
            this.cache.getNode("/a/1");
            Set children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
            children = this.cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren11() {
        try {
            this.cache.put("/a/b", (Object)"key", (Object)"val");
            this.cache.put("/a/b/1", (Object)"key", (Object)"val");
            this.cache.put("/a/b/2", (Object)"key", (Object)"val");
            this.cache.put("/a/b/3", (Object)"key", (Object)"val");
            this.cache.put("/a/b/1/tmp", (Object)"key", (Object)"val");
            this.cache.put("/a/b/2/tmp", (Object)"key", (Object)"val");
            this.cache.put("/a/b/3/tmp", (Object)"key", (Object)"val");
            this.cache.evict(Fqn.fromString((String)"/a"));
            this.cache.evict(Fqn.fromString((String)"/a/b"));
            this.cache.evict(Fqn.fromString((String)"/a/b/1"));
            this.cache.evict(Fqn.fromString((String)"/a/b/2"));
            this.cache.evict(Fqn.fromString((String)"/a/b/3"));
            Set children = this.cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
            this.cache.evict(Fqn.fromString((String)"/a/b"));
            this.cache.evict(Fqn.fromString((String)"/a/b/1/tmp"));
            this.cache.evict(Fqn.fromString((String)"/a/b/2/tmp"));
            this.cache.evict(Fqn.fromString((String)"/a/b/3/tmp"));
            this.cache.evict(Fqn.fromString((String)"/a/b/1"));
            this.cache.evict(Fqn.fromString((String)"/a/b/2"));
            this.cache.evict(Fqn.fromString((String)"/a/b/3"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            children = this.cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren12() {
        try {
            this.cache.put("/a/b", (Object)"key", (Object)"val");
            this.cache.put("/a/b/1", (Object)"key", (Object)"val");
            this.cache.put("/a/b/2", (Object)"key", (Object)"val");
            this.cache.put("/a/b/3", (Object)"key", (Object)"val");
            Set children = this.cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
            this.cache.evict(Fqn.fromString((String)"/a/b/3"));
            this.cache.evict(Fqn.fromString((String)"/a/b/2"));
            this.cache.evict(Fqn.fromString((String)"/a/b"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            NodeSPI n = this.cache.getNode("/a/b");
            assert (!n.isChildrenLoaded());
            children = this.cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
            this.cache.evict(Fqn.fromString((String)"/a/b/3"));
            this.cache.evict(Fqn.fromString((String)"/a/b/2"));
            this.cache.evict(Fqn.fromString((String)"/a/b"));
            this.cache.evict(Fqn.fromString((String)"/a"));
            children = this.cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testLoaderGetChildrenNames() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        this.cache.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", this.loader.get(f).get("k"));
        AssertJUnit.assertNull((Object)this.loader.getChildrenNames(f));
    }

    public void testGetKeys() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        this.cache.put(f, (Object)"one", (Object)"one");
        this.cache.put(f, (Object)"two", (Object)"two");
        this.cache.evict(f);
        Set keys = this.cache.getRoot().getChild(f).getKeys();
        AssertJUnit.assertEquals((String)"Correct # of keys", (int)2, (int)keys.size());
        AssertJUnit.assertTrue((String)"Has key 'one", (boolean)keys.contains("one"));
        AssertJUnit.assertTrue((String)"Has key 'two", (boolean)keys.contains("two"));
    }

    public void testGetData() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        this.cache.put(f, (Object)"one", (Object)"one");
        this.cache.put(f, (Object)"two", (Object)"two");
        this.cache.evict(f);
        Map data = this.cache.getRoot().getChild(f).getData();
        AssertJUnit.assertEquals((String)"Correct # of entries", (int)2, (int)data.size());
        AssertJUnit.assertEquals((String)"Has key 'one", (Object)"one", data.get("one"));
        AssertJUnit.assertEquals((String)"Has key 'two", (Object)"two", data.get("two"));
    }

    public void testRemoveData() {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)this.cache.getNode(key).getKeys().size());
        this.cache.getNode(key).clearData();
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)0, (int)keys.size());
        this.cache.removeNode("/x");
        Object val = this.cache.get(key, (Object)"keyA");
        AssertJUnit.assertNull((Object)val);
    }

    public void testRemoveData2() {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.addDelay();
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.getNode(key).clearData();
        this.cache.evict(key);
        this.addDelay();
        keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveData3() {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.evict(key);
        this.cache.getNode(key).clearData();
        keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((String)"no more keys", (int)0, (int)keys.size());
    }

    public void testRemoveData4() throws Exception {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.evict(key);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("keyA", "valA");
        map.put("keyB", "valB");
        map.put("keyC", "valC");
        AssertJUnit.assertEquals(map, (Object)this.loader.get(key));
        Node n = this.cache.getRoot().getChild(key);
        n.clearData();
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)this.loader.get(key));
    }

    public void testReplaceAll() throws Exception {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.evict(key);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("keyA", "valA");
        map.put("keyB", "valB");
        map.put("keyC", "valC");
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("keyD", "valD");
        newMap.put("keyE", "valE");
        AssertJUnit.assertEquals(map, (Object)this.loader.get(key));
        Node n = this.cache.getRoot().getChild(key);
        n.replaceAll(newMap);
        AssertJUnit.assertEquals(newMap, (Object)this.loader.get(key));
    }

    public void testRemoveKey() {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        AssertJUnit.assertEquals((int)1, (int)this.cache.getNode(key).getKeys().size());
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNode(key).getKeys().size());
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)this.cache.getNode(key).getKeys().size());
        this.cache.remove(key, (Object)"keyA");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNode(key).getKeys().size());
        this.cache.removeNode("/x");
    }

    public void testRemoveKey2() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        this.cache.removeNode("/test");
        Object retval = this.cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = this.cache.remove("/test", (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.addDelay();
        retval = this.cache.remove("/test", (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemoveKey3() throws CacheException {
        String NODE = "/test";
        String KEY = "key";
        this.cache.removeNode("/test");
        Object retval = this.cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.cache.evict(Fqn.fromString((String)"/test"));
        this.addDelay();
        retval = this.cache.remove("/test", (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.cache.evict(Fqn.fromString((String)"/test"));
        this.addDelay();
        retval = this.cache.remove("/test", (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemove() {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.cache.removeNode("/x");
        AssertJUnit.assertNull((Object)this.cache.get(key, (Object)"keyA"));
        this.addDelay();
        Set keys = this.cache.getKeys(key);
        AssertJUnit.assertNull((String)("got keys " + keys), (Object)keys);
        this.cache.removeNode("/x");
    }

    public void testRemoveRoot() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getKeys().size());
        this.cache.put("/1/2/3/4/5", null);
        this.cache.put("uno/due/tre", null);
        this.cache.put("1/2/3/a", null);
        this.cache.put("/eins/zwei/drei", null);
        this.cache.put("/one/two/three", null);
        this.cache.removeNode(Fqn.ROOT);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getKeys().size());
    }

    public void testLoaderRemoveRoot() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        this.loader.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.loader.get(f).containsKey("k"));
        this.loader.remove(f);
        AssertJUnit.assertNull((Object)this.loader.get(f));
        this.loader.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.loader.get(f).containsKey("k"));
        this.loader.remove(Fqn.ROOT);
        AssertJUnit.assertNull((String)"Removing Fqn.ROOT should cause all children to be removed as well", (Object)this.loader.get(f));
    }

    public void testEvictionWithCacheLoader() {
        this.cache.put("/first/second", (Object)"key1", (Object)"val1");
        this.cache.put("/first/second/third", (Object)"key2", (Object)"val2");
        this.cache.evict(Fqn.fromString((String)"/first/second"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first"));
        String val = (String)this.cache.get("/first/second", (Object)"key1");
        AssertJUnit.assertEquals((String)"val1", (String)val);
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first"));
    }

    public void testEvictionWithCacheLoader2() {
        this.cache.put("/first/second/third", (Object)"key1", (Object)"val1");
        this.cache.evict(Fqn.fromString((String)"/first/second/third"));
        this.addDelay();
        assert (!this.exists("/first/second/third", null));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first"));
        String val = (String)this.cache.get("/first/second/third", (Object)"key1");
        AssertJUnit.assertEquals((String)"val1", (String)val);
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)this.cache.exists("/first"));
    }

    public void testEvictionWithGetChildrenNames() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        Set children = this.cache.getNode("/a").getChildrenNames();
        System.out.println("**** " + this.cache.getTransactionManager());
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfLocksHeld());
        mgr.commit();
    }

    public void testTxPutCommit() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.commit();
        AssertJUnit.assertNotNull((String)"Cache has node /one/two/three", (Object)this.cache.getNode("/one/two/three").getKeys());
        AssertJUnit.assertNotNull((String)"Loader has node /one/two/three", (Object)this.loader.get(Fqn.fromString((String)"/one/two/three")));
        Set children = this.cache.getNode("/one").getChildrenNames();
        AssertJUnit.assertEquals((String)"Cache has correct number of children", (int)1, (int)children.size());
        children = this.loader.getChildrenNames(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((String)"Loader has correct number of children", (int)1, (int)children.size());
        this.cache.removeNode(Fqn.ROOT);
    }

    public void testTxPutRollback() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        this.cache.removeNode("/one");
        this.addDelay();
        mgr.begin();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        log.debug((Object)("NODE1 " + this.cache.getNode("/one/two/three").getData()));
        mgr.rollback();
        log.debug((Object)("NODE2 " + this.cache.getNode("/one/two/three")));
        AssertJUnit.assertEquals(null, (Object)this.cache.get("/one/two/three", (Object)"key1"));
        AssertJUnit.assertEquals(null, (Object)this.cache.get("/one/two/three/four", (Object)"key2"));
        this.addDelay();
        AssertJUnit.assertNull((String)"Loader does not have node /one/two/three", (Object)this.loader.get(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertNull((String)"Cache does not have node /one/two/three", (Object)this.cache.getKeys("/one/two/three"));
        Set children = this.cache.getChildrenNames("/one");
        AssertJUnit.assertEquals((String)"Cache has no children under /one", (int)0, (int)children.size());
        children = this.loader.getChildrenNames(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((String)"Loader has no children under /one", null, (Object)children);
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations();
    }

    public void testBasicOperationsTransactional() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        this.doTestBasicOperations();
        mgr.commit();
    }

    private void doTestBasicOperations() throws Exception {
        this.doPutTests(new Fqn((Object[])new String[]{"key"}));
        this.doRemoveTests(new Fqn((Object[])new String[]{"key"}));
        this.doPutTests(new Fqn((Object[])new String[]{"key1"}));
        this.doPutTests(new Fqn((Object[])new String[]{"key3"}));
        this.doPutTests(new Fqn((Object[])new String[]{"key2"}));
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key1"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key2"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key3"})).size());
        this.doRemoveTests(new Fqn((Object[])new String[]{"key2"}));
        this.doRemoveTests(new Fqn((Object[])new String[]{"key3"}));
        this.doRemoveTests(new Fqn((Object[])new String[]{"key1"}));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
    }

    private void doPutTests(Fqn fqn) throws Exception {
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"three", (Object)"four");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", this.loader.get(fqn).get("one"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"xxx");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"xxx", (Object)oldVal);
        this.addDelay();
        HashMap<String, String> map = new HashMap<String, String>(this.loader.get(fqn));
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"two", map.get("one"));
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        map.put("five", "six");
        map.put("seven", "eight");
        this.loader.put(fqn, map);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"six", this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        AssertJUnit.assertEquals(map, (Object)this.loader.get(fqn));
        AssertJUnit.assertEquals((int)4, (int)map.size());
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
    }

    private void doRemoveTests(Fqn fqn) throws Exception {
        Object oldVal = this.loader.remove(fqn, (Object)"one");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = this.loader.remove(fqn, (Object)"five");
        AssertJUnit.assertEquals((Object)"six", (Object)oldVal);
        this.addDelay();
        AssertJUnit.assertNull(this.loader.get(fqn).get("one"));
        AssertJUnit.assertNull(this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        Map map = this.loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        AssertJUnit.assertEquals((Object)"eight", map.get("seven"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
        this.loader.remove(fqn);
        this.addDelay();
        map = this.loader.get(fqn);
        AssertJUnit.assertNull((String)"Should be null", (Object)map);
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x/y")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x")) ? 1 : 0) != 0);
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key2"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/level1")).size());
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(new Fqn((Object[])new String[]{"key0"})).size());
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/x")).size());
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key0/x")).size());
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(Fqn.fromString((String)"/key3/level1")).size());
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
    }

    public void testGetChildrenNames() throws Exception {
        this.checkChildren(new Fqn(), null);
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.loader.put(Fqn.fromString((String)"/key0"), null);
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0"});
        this.loader.put(Fqn.fromString((String)"/key1/x"), null);
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key1"), new String[]{"x"});
        this.loader.remove(Fqn.fromString((String)"/key1/x"));
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.checkChildren(Fqn.fromString((String)"/key1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a"), null);
        this.loader.put(Fqn.fromString((String)"/key0/ab"), null);
        this.loader.put(Fqn.fromString((String)"/key0/abc"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc"});
        this.loader.put(Fqn.fromString((String)"/key0/xxx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/xx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString((String)"/key0/a/1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2/1"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString((String)"/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        Set set = this.loader.getChildrenNames(fqn);
        if (names != null) {
            AssertJUnit.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                AssertJUnit.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            AssertJUnit.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications();
    }

    public void testModificationsTransactional() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        this.doTestModifications();
        mgr.commit();
    }

    private void doTestModifications() throws Exception {
        List<Modification> list = this.createUpdates();
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_NODE);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        AssertJUnit.assertNull((Object)this.loader.get(FQN));
        this.loader.put(FQN, (Object)"one", (Object)"two");
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_DATA);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
    }

    public void testOnePhaseTransaction() throws Exception {
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(null, mods, true);
        this.checkModifications(mods);
    }

    public void testTwoPhaseTransaction() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare((Object)tx, mods, false);
        this.loader.commit((Object)tx);
        this.addDelay();
        this.checkModifications(mods);
        mgr.commit();
    }

    public void testTransactionRollback() throws Exception {
        int num;
        this.loader.remove(Fqn.fromString((String)"/"));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
            this.loader.loadEntireState((ObjectOutputStream)os);
            num = baos.size();
        }
        catch (UnsupportedOperationException ex) {
            log.info((Object)"caught unsupported operation exception that's okay: ", (Throwable)ex);
            return;
        }
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    public void testIntegratedTransactionRollback() throws Exception {
        this.loader.remove(Fqn.fromString((String)"/"));
        int num = 0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
            this.loader.loadEntireState((ObjectOutputStream)os);
            num = baos.size();
        }
        catch (UnsupportedOperationException ex) {
            System.out.println("caught unsupported operation exception that's okay: " + ex);
            return;
        }
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    private List<Modification> createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        mod.setValue((Object)"two");
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"three");
        mod.setValue((Object)"four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_DATA);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List<Modification> list) throws Exception {
        block7: for (Modification mod : list) {
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    AssertJUnit.assertEquals((Object)mod.getValue(), this.loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case PUT_DATA: {
                    Map map = mod.getData();
                    for (Object key : map.keySet()) {
                        AssertJUnit.assertEquals(map.get(key), this.loader.get(fqn).get(key));
                    }
                    continue block7;
                }
                case REMOVE_KEY_VALUE: {
                    AssertJUnit.assertNull(this.loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case REMOVE_DATA: {
                    Map map = this.loader.get(fqn);
                    AssertJUnit.assertNotNull((Object)map);
                    AssertJUnit.assertEquals((int)0, (int)map.size());
                    break;
                }
                case REMOVE_NODE: {
                    AssertJUnit.assertNull((Object)this.loader.get(fqn));
                    break;
                }
                default: {
                    AssertJUnit.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testNullKeysAndValues() throws Exception {
        this.loader.put(FQN, null, (Object)"x");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"x", this.loader.get(FQN).get(null));
        HashMap<Object, Object> map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)1, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        this.loader.put(FQN, (Object)"y", null);
        this.addDelay();
        AssertJUnit.assertNull(this.loader.get(FQN).get("y"));
        map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        AssertJUnit.assertNull(map.get("y"));
        this.loader.remove(FQN, null);
        this.addDelay();
        AssertJUnit.assertNull(this.loader.get(FQN).get(null));
        AssertJUnit.assertEquals((int)1, (int)this.loader.get(FQN).size());
        this.loader.remove(FQN, (Object)"y");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(FQN));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(FQN).size());
        map = new HashMap<Object, Object>();
        map.put(null, null);
        this.loader.put(FQN, map);
        this.addDelay();
        Map m = this.loader.get(FQN);
        m.toString();
    }

    public void testDatabaseName() throws Exception {
        this.loader.put(FQN, (Object)"one", (Object)"two");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", this.loader.get(FQN).get("one"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadAndStore() throws Exception {
        byte[] state2;
        this.loader.remove(Fqn.fromString((String)"/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        this.loader.put(FQN, (Object)1, (Object)c1);
        this.loader.put(FQN, (Object)2, (Object)c2);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        try {
            this.loader.loadEntireState((ObjectOutputStream)os);
        }
        catch (UnsupportedOperationException ex) {
            try {
                System.out.println("caught unsupported operation exception (this is expected): " + ex);
            }
            catch (Throwable throwable) {
                this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
                os.close();
                AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
                byte[] state2 = baos.toByteArray();
                throw throwable;
            }
            this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
            os.close();
            AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
            state2 = baos.toByteArray();
        }
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        state2 = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(state2);
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        try {
            this.loader.storeEntireState((ObjectInputStream)is);
        }
        catch (UnsupportedOperationException ex) {
            System.out.println("caught unsupported operation exception (this is expected): " + ex);
        }
        finally {
            is.close();
        }
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
    }

    public void testRemoveInTransactionCommit() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.loader.remove(fqn);
        String key = "key";
        String value = "value";
        this.cache.put(fqn, (Object)key, (Object)value);
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, this.loader.get(fqn).get(key));
        this.cache.getTransactionManager().begin();
        this.cache.removeNode(fqn);
        this.cache.getNode(fqn);
        this.cache.getTransactionManager().commit();
        log.debug((Object)"expect the cache and the loader to be null here.");
        AssertJUnit.assertEquals(null, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(fqn));
    }

    public void testRemoveInTransactionRollback() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.loader.remove(fqn);
        String key = "key";
        String value = "value";
        this.cache.put(fqn, (Object)key, (Object)value);
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, this.loader.get(fqn).get(key));
        this.cache.getTransactionManager().begin();
        this.cache.removeNode(fqn);
        this.cache.getNode(fqn);
        this.cache.getTransactionManager().rollback();
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, this.loader.get(fqn).get(key));
    }

    public void testRemoveAndGetInTransaction() throws Exception {
        Fqn fqn = new Fqn((Object[])new String[]{"/a/b"});
        String key = "key";
        String value = "value";
        this.cache.put(fqn, (Object)key, (Object)value);
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
        this.cache.getTransactionManager().begin();
        this.cache.removeNode(fqn);
        AssertJUnit.assertNull((String)"Expecting a null since I have already called a remove() - see JBCACHE-352", (Object)this.cache.get(fqn, (Object)key));
        this.cache.getTransactionManager().rollback();
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
    }

    public void testPartialLoadAndStore() throws Exception {
        this.loader.remove(Fqn.fromString((String)"/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        Complex c3 = new Complex();
        Complex c4 = new Complex(c3);
        this.loader.put(FQN, (Object)1, (Object)c1);
        this.loader.put(FQN, (Object)2, (Object)c2);
        this.loader.put(SUBTREE_FQN, (Object)1, (Object)c3);
        this.loader.put(SUBTREE_FQN, (Object)2, (Object)c4);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, this.loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, this.loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(SUBTREE_FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadState(SUBTREE_FQN, (ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        this.loader.remove(SUBTREE_FQN);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeState(SUBTREE_FQN, (ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, this.loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, this.loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(SUBTREE_FQN).size());
    }

    public void testBuddyBackupStore() throws Exception {
        this.loader.remove(Fqn.ROOT);
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        Complex c3 = new Complex();
        Complex c4 = new Complex(c3);
        this.loader.put(FQN, (Object)1, (Object)c1);
        this.loader.put(FQN, (Object)2, (Object)c2);
        this.loader.put(SUBTREE_FQN, (Object)1, (Object)c3);
        this.loader.put(SUBTREE_FQN, (Object)2, (Object)c4);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, this.loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, this.loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(SUBTREE_FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadState(FQN, (ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeState(BUDDY_BASE, (ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(BUDDY_PLUS_FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(BUDDY_PLUS_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(BUDDY_PLUS_FQN).size());
        AssertJUnit.assertEquals((Object)c3, this.loader.get(BUDDY_PLUS_SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, this.loader.get(BUDDY_PLUS_SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(BUDDY_PLUS_SUBTREE_FQN).size());
    }

    public void testIgnoreModifications() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/a");
        this.cache.put(fqn, (Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get(fqn, (Object)"k")));
        assert ("v".equals(this.loader.get(fqn).get("k")));
        assert ("v".equals(this.loader.get(fqn).get("k")));
        this.cache.stop();
        this.cache.destroy();
        assert (this.cache.getCacheLoaderManager() == null) : "Should nullify cache loader manager in the cache";
        ((CacheLoaderConfig.IndividualCacheLoaderConfig)this.cache.getConfiguration().getCacheLoaderConfig().getIndividualCacheLoaderConfigs().get(0)).setIgnoreModifications(true);
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
        this.postConfigure();
        if (!(this.loader instanceof ChainingCacheLoader)) assert (this.loader instanceof ReadOnlyDelegatingCacheLoader);
        assert ("v".equals(this.loader.get(fqn).get("k")));
        assert ("v".equals(this.cache.get(fqn, (Object)"k")));
        this.cache.put(fqn, (Object)"k", (Object)"v2");
        assert ("v2".equals(this.cache.get(fqn, (Object)"k")));
        assert ("v".equals(this.loader.get(fqn).get("k")));
    }

    public void testCacheLoaderThreadSafety() throws Exception {
        this.threadSafetyTest(true);
    }

    public void testCacheLoaderThreadSafetyMultipleFqns() throws Exception {
        this.threadSafetyTest(false);
    }

    protected void threadSafetyTest(final boolean singleFqn) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/a/b/c");
        final ArrayList<Fqn> fqns = new ArrayList<Fqn>(30);
        final Random r = new Random();
        if (!singleFqn) {
            for (int i = 0; i < 30; ++i) {
                Fqn f = Fqn.fromString((String)("/a/b/c/" + i));
                fqns.add(f);
                this.loader.put(f, (Object)"k", (Object)"v");
            }
        } else {
            this.loader.put(fqn, (Object)"k", (Object)"v");
        }
        int loops = 1000;
        final CopyOnWriteArraySet exceptions = new CopyOnWriteArraySet();
        Thread remover1 = new Thread("Remover-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.remove(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        remover1.start();
        Thread remover2 = new Thread("Remover-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.remove(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), (Object)"k");
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        remover2.start();
        Thread reader1 = new Thread("Reader-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.get(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader1.start();
        Thread reader2 = new Thread("Reader-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.getChildrenNames(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader2.start();
        Thread writer1 = new Thread("Writer-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.put(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), (Object)"k", (Object)"v");
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        writer1.start();
        Thread writer2 = new Thread("Writer-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        CacheLoaderTestsBase.this.loader.put(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), new HashMap());
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        writer2.start();
        latch.countDown();
        reader1.join();
        reader2.join();
        remover1.join();
        remover2.join();
        writer1.join();
        writer2.join();
        Iterator i$ = exceptions.iterator();
        if (i$.hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
    }

    protected TransactionManager getTransactionManager() {
        return this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    public static class Complex
    implements Serializable {
        private static final long serialVersionUID = -6810871775584708565L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Complex)) {
                return false;
            }
            Complex x = (Complex)o;
            return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
        }

        public int hashCode() {
            if (this.nested == null) {
                return super.hashCode();
            }
            return 13 + this.nested.hashCode();
        }
    }
}

