/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.event.Event;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ConcurrentNotificationTest {
    private Cache<String, String> cache;
    private Listener listener;
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");
    private static final Log log = LogFactory.getLog(ConcurrentNotificationTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache = instance.createCache();
        this.listener = new Listener();
        this.cache.addCacheListener((Object)this.listener);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
    }

    public void testNulls() {
        this.cache.put(this.fqn, (Object)"key", null);
        this.cache.put(this.fqn, null, (Object)"value");
    }

    public void testThreads() throws Exception {
        Thread[] workers = new Thread[20];
        final LinkedList exceptions = new LinkedList();
        int loops = 100;
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new Thread(){

                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int j = 0; j < 100; ++j) {
                        try {
                            ConcurrentNotificationTest.this.cache.put(ConcurrentNotificationTest.this.fqn, (Object)"key", (Object)"value");
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception doing put in loop " + j), (Throwable)e);
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a put()", e));
                        }
                        try {
                            ConcurrentNotificationTest.this.cache.remove(ConcurrentNotificationTest.this.fqn, (Object)"key");
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception doing remove in loop " + j), (Throwable)e);
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a remove()", e));
                        }
                        try {
                            ConcurrentNotificationTest.this.cache.get(ConcurrentNotificationTest.this.fqn, (Object)"key");
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception doing get in loop " + j), (Throwable)e);
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a get()", e));
                        }
                    }
                }
            };
            workers[i].start();
        }
        latch.countDown();
        for (Thread t : workers) {
            t.join();
        }
        Iterator i$ = exceptions.iterator();
        if (i$.hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
        AssertJUnit.assertEquals((int)(300 * workers.length + 3), (int)this.listener.counter.get());
    }

    @CacheListener
    public class Listener {
        private AtomicInteger counter = new AtomicInteger(0);

        @NodeModified
        @NodeRemoved
        @NodeVisited
        @NodeCreated
        public void catchEvent(Event e) {
            if (e.isPre()) {
                this.counter.getAndIncrement();
            }
        }
    }
}

