/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"})
public class AsyncCacheTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private CacheSPI<Object, Object> cache2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = this.createReplicatedCache(Configuration.CacheMode.REPL_ASYNC);
        this.cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_ASYNC);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.destroyCache((Cache<Object, Object>)this.cache2);
        this.cache = null;
        this.cache2 = null;
    }

    @Override
    protected CacheSPI<Object, Object> createCacheUnstarted(boolean optimistic) throws Exception {
        CacheSPI<Object, Object> cache = super.createCacheUnstarted(optimistic);
        cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        return cache;
    }

    public void testRemoteCacheBroadcast() throws Exception {
        AssertJUnit.assertEquals((int)2, (int)this.cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache2.getMembers().size());
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)this.cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)this.cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        TestingUtil.sleepThread(1000L);
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)this.cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)this.cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
    }

    public void testTwoWayRemoteCacheBroadcast() throws Exception {
        AssertJUnit.assertEquals((int)2, (int)this.cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)this.cache2.getMembers().size());
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, false);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)this.cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)this.cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        TestingUtil.sleepThread(1000L);
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)this.cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)this.cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)pojo, (Object)this.cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
    }
}

