/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.testng.AssertJUnit;

class LockReportInterceptor
extends OptimisticInterceptor {
    private Map<Fqn, NodeLock.LockType> expected = new HashMap<Fqn, NodeLock.LockType>();
    private Map<Fqn, NodeLock.LockType> actual = new HashMap<Fqn, NodeLock.LockType>();

    LockReportInterceptor() {
    }

    void reset() {
        this.expected.clear();
        this.actual.clear();
    }

    void assertReceivedExpectedLocks() {
        AssertJUnit.assertEquals(this.expected, this.actual);
    }

    void expectsReadLock(Fqn f) {
        this.expected.put(f, NodeLock.LockType.READ);
    }

    void expectsWriteLock(Fqn f) {
        this.expected.put(f, NodeLock.LockType.WRITE);
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        TransactionWorkspace w = this.getTransactionWorkspace(ctx.getGlobalTransaction());
        Map nodeMap = w.getNodes();
        Iterator i = nodeMap.keySet().iterator();
        while (i.hasNext()) {
            WorkspaceNode wn = (WorkspaceNode)nodeMap.get(i.next());
            NodeSPI n = wn.getNode();
            NodeLock lock = n.getLock();
            if (!lock.isLocked()) continue;
            this.actual.put(n.getFqn(), lock.isReadLocked() ? NodeLock.LockType.READ : NodeLock.LockType.WRITE);
        }
        return super.invoke(ctx);
    }
}

