/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NodeInterceptorRemoveKeyValTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TransactionManager mgr;
    private TestListener listener;
    private MockInterceptor dummy;

    @BeforeMethod
    public void setUp() throws Exception {
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = TestingUtil.findInterceptor(this.cache, OptimisticCreateIfNotExistsInterceptor.class);
        OptimisticNodeInterceptor nodeInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticNodeInterceptor.class);
        this.dummy = new MockInterceptor();
        interceptor.setNext((Interceptor)nodeInterceptor);
        nodeInterceptor.setNext((Interceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (Interceptor)interceptor);
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    public void testTransactionRemoveNoNodeKeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        this.cache.remove("/one/two", (Object)"keyOne");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionRemoveNoKeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        this.cache.remove("/one/two", (Object)"key2");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key2"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionRemoveKeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        this.cache.remove("/one/two", (Object)"key1");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }
}

