/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockFailureInterceptor;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class OptimisticReplicationInterceptorTest
extends AbstractOptimisticTestCase {
    private CacheSPI cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = this.createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    public void testLocalTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
    }

    public void testRollbackTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        mgr.begin();
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((int)1, (int)calls.size());
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(0));
    }

    public void testRemotePrepareTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx, true);
        TransactionTable table = this.cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new TestAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), false});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteRollbackTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx, true);
        TransactionTable table = this.cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new TestAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), false});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        MethodCall rollbackMethod = MethodCallFactory.create((int)12, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(rollbackMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(3));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteCommitNoPrepareTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx, true);
        TransactionTable table = this.cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new TestAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((int)2, (int)calls.size());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(commitMethod);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)(t instanceof RuntimeException));
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)2, (int)calls.size());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteRollbackNoPrepareTransaction() throws Throwable {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx, true);
        TransactionTable table = this.cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new TestAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((int)2, (int)calls.size());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        MethodCall rollbackMethod = MethodCallFactory.create((int)12, (Object[])new Object[]{remoteGtx});
        TestingUtil.getRemoteDelegate(this.cache)._replicate(rollbackMethod);
        AssertJUnit.assertTrue((String)"Should be handled on the remote end without barfing, in the event of a rollback without a prepare", (boolean)true);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)2, (int)calls.size());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteCommitTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        GlobalTransaction gtx = this.cache.getCurrentTransaction(tx, true);
        TransactionTable table = this.cache.getTransactionTable();
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new TestAddress());
        MethodCall meth = (MethodCall)entry.getModifications().get(0);
        meth.getArgs()[0] = remoteGtx;
        MethodCall prepareMethod = MethodCallFactory.create((int)18, (Object[])new Object[]{remoteGtx, this.injectDataVersion(entry.getModifications()), null, remoteGtx.getAddress(), false});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(prepareMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)1, (int)table.get(remoteGtx).getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        MethodCall commitMethod = MethodCallFactory.create((int)11, (Object[])new Object[]{remoteGtx});
        try {
            TestingUtil.getRemoteDelegate(this.cache)._replicate(commitMethod);
        }
        catch (Throwable t) {
            AssertJUnit.fail();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(3));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
    }

    public void testTwoWayRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        CacheSPI cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockInterceptor dummy2 = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy2, (CacheSPI<Object, Object>)cache2);
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls.get(1));
        List<Integer> calls2 = dummy2.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls2.get(0));
        AssertJUnit.assertEquals((Object)11, (Object)calls2.get(1));
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testFailurePrepareRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        CacheSPI cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockFailureInterceptor dummy2 = new MockFailureInterceptor();
        ArrayList<Method> failures = new ArrayList<Method>();
        failures.add(MethodDeclarations.optimisticPrepareMethod);
        dummy2.setFailurelist(failures);
        this.setAlteredInterceptorChain(dummy2, (CacheSPI<Object, Object>)cache2);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        try {
            mgr.commit();
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((boolean)(e instanceof RollbackException));
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)18, (Object)calls.get(0));
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(1));
        List<Integer> calls2 = dummy2.getAllCalledIds();
        AssertJUnit.assertEquals((Object)12, (Object)calls2.get(0));
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testFailurePrepareLocalCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockFailureInterceptor dummy = new MockFailureInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        CacheSPI cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        MockInterceptor dummy2 = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, (CacheSPI<Object, Object>)this.cache);
        ArrayList<Method> failures = new ArrayList<Method>();
        failures.add(MethodDeclarations.optimisticPrepareMethod);
        dummy.setFailurelist(failures);
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.getCurrentTransaction(tx, true);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        try {
            mgr.commit();
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((boolean)(e instanceof RollbackException));
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        List<Integer> calls = dummy.getAllCalledIds();
        AssertJUnit.assertEquals((Object)12, (Object)calls.get(0));
        List<Integer> calls2 = dummy2.getAllCalledIds();
        AssertJUnit.assertEquals((int)0, (int)calls2.size());
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    static class TestAddress
    implements Address {
        private static final long serialVersionUID = -8525272532201600656L;

        TestAddress() {
        }

        public boolean isMulticastAddress() {
            return false;
        }

        public void readExternal(ObjectInput arg0) {
        }

        public int size() {
            return 0;
        }

        public void writeExternal(ObjectOutput arg0) {
        }

        public void writeTo(DataOutputStream arg0) {
        }

        public void readFrom(DataInputStream arg0) {
        }

        public int compareTo(Object arg0) {
            return 0;
        }
    }
}

