/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LocalPassivationIntegrationTest {
    CacheSPI<String, String> cache;
    protected static final Log log = LogFactory.getLog(LocalPassivationIntegrationTest.class);
    int wakeupIntervalMillis_ = 0;
    PassivationListener listener_;
    private static final int LISTENER_WAIT_TIME = 200;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache = (CacheSPI)instance.createCache(new XmlConfigurationParser().parseFile("META-INF/conf-test/local-passivation-service.xml"), false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        this.cache.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache.start();
        this.listener_ = new PassivationListener();
        this.cache.getNotifier().addCacheListener((Object)this.listener_);
        this.listener_.resetCounter();
        this.wakeupIntervalMillis_ = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ <= 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testActivationEvent() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        String str = rootStr + "0";
        this.cache.removeNode(Fqn.ROOT);
        this.listener_.resetCounter();
        this.cache.put(str, (Object)str, (Object)str);
        TestingUtil.sleepThread(20000L);
        AssertJUnit.assertFalse((String)"UnversionedNode should not exist", (boolean)this.cache.exists(str));
        String val = (String)this.cache.get(str, (Object)str);
        AssertJUnit.assertNotNull((String)"DataNode should be activated ", (Object)val);
        TestingUtil.sleepThread(200L);
        AssertJUnit.assertEquals((String)"Eviction counter ", (int)1, (int)this.listener_.getCounter());
    }

    private void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class PassivationListener {
        int counter = 0;
        int loadedCounter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
            this.loadedCounter = 0;
        }

        @NodeActivated
        public void nodeActivated(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.counter;
                System.out.println("nodeActivate(): counter: " + this.counter);
            }
        }

        @NodePassivated
        public void nodePassivated(NodeEvent ne) {
            if (ne.isPre()) {
                System.out.println("nodePassivate(): " + ne.getFqn());
            }
        }

        @NodeLoaded
        public void nodeLoaded(Event e) {
            if (!e.isPre()) {
                ++this.loadedCounter;
            }
        }
    }
}

