/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.xml.XmlHelper;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class PassivationTestsBase {
    Log log = LogFactory.getLog(this.getClass());
    CacheSPI<Object, Object> cache;
    CacheLoader loader = null;
    static final Fqn<String> FQN = new Fqn((Object[])new String[]{"key"});

    protected CacheLoaderConfig getCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState) throws Exception {
        String xml = "<config>\n<passivation>true</passivation>\n<preload>" + preload + "</preload>\n" + "<cacheloader>\n" + "<class>" + cacheloaderClass + "</class>\n" + "<properties>" + properties + "</properties>\n" + "<async>" + async + "</async>\n" + "<fetchPersistentState>" + fetchPersistentState + "</fetchPersistentState>\n" + "</cacheloader>\n" + "</config>";
        Element element = XmlHelper.stringToElement((String)xml);
        return XmlConfigurationParser.parseCacheLoaderConfig((Element)element);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.configureCache();
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.create();
        this.cache.start();
        this.loader = this.cache.getCacheLoaderManager().getCacheLoader();
    }

    protected abstract void configureCache() throws Exception;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.loader.remove(Fqn.ROOT);
        TestingUtil.killCaches(new Cache[]{this.cache});
    }

    protected void addDelay() {
    }

    protected boolean exists(String fqn, String key) {
        NodeSPI n = this.cache.peek(Fqn.fromString((String)fqn), false, false);
        if (key == null) {
            return n != null;
        }
        return n != null && n.getKeysDirect().contains(key);
    }

    protected boolean exists(String fqn) {
        return this.exists(fqn, null);
    }

    public void testPutPassivation() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        Object retval = null;
        this.cache.removeNode(NODE);
        this.addDelay();
        retval = this.cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        retval = this.cache.put(NODE, (Object)"key", (Object)20);
        this.addDelay();
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.cache.evict(NODE, true);
        this.addDelay();
        this.log.debug((Object)"______________");
        retval = this.cache.put(NODE, (Object)"key", (Object)30);
        AssertJUnit.assertFalse((boolean)this.loader.exists(NODE));
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut2Passivation() throws CacheException {
        Fqn NODE = Fqn.fromString((String)"/a/b/c");
        String KEY = "key";
        this.cache.removeNode(NODE);
        this.addDelay();
        Object retval = this.cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = this.cache.put(NODE, (Object)"key", (Object)20);
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.cache.evict(NODE, true);
        this.cache.evict(Fqn.fromString((String)"/a/b"), true);
        this.cache.evict(Fqn.fromString((String)"/a"), true);
        this.addDelay();
        try {
            AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c")));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        retval = this.cache.put(NODE, (Object)"key", (Object)30);
        try {
            AssertJUnit.assertFalse((boolean)this.loader.exists(NODE));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testSerializationPassivation() throws CacheException {
        Fqn fqn = Fqn.fromString((String)"/mypojo");
        SamplePojo pojo = new SamplePojo(39, "Hany");
        pojo.getHobbies().add("Running");
        pojo.getHobbies().add("Beerathlon");
        pojo.getHobbies().add("Triathlon");
        this.cache.put(fqn, (Object)322649, (Object)pojo);
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)322649));
        this.cache.evict(fqn, false);
        try {
            AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        SamplePojo pojo2 = (SamplePojo)this.cache.get(fqn, (Object)322649);
        try {
            AssertJUnit.assertFalse((boolean)this.loader.exists(fqn));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        AssertJUnit.assertNotNull((Object)pojo2);
        AssertJUnit.assertEquals((int)39, (int)pojo2.getAge());
        AssertJUnit.assertEquals((String)"Hany", (String)pojo2.getName());
        AssertJUnit.assertEquals((int)3, (int)pojo2.getHobbies().size());
    }

    public void testPopulate() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < 10; ++i) {
                m.put("key" + i, "val" + i);
            }
            this.cache.put("/a/b/c", m);
            this.cache.getCacheLoaderManager().preload(Fqn.fromString((String)"/1/2/3/4/5"), true, true);
            this.cache.put("/1/2/3/4/5", null);
            this.cache.put("/1/2/3/4/5/a", null);
            this.cache.put("/1/2/3/4/5/b", null);
            this.cache.put("/1/2/3/4/5/c", null);
            this.cache.put("/1/2/3/4/5/d", null);
            this.cache.put("/1/2/3/4/5/e", null);
            this.cache.put("/1/2/3/4/5/d/one", null);
            this.cache.put("/1/2/3/4/5/d/two", null);
            this.cache.put("/1/2/3/4/5/d/three", null);
            System.out.println("cache: " + this.cache);
            assert (this.exists("/1/2/3/4"));
            assert (this.exists("/a/b/c"));
            assert (!this.exists("/a/b/c/d"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testPreloadingPassivation() throws Exception {
        this.cache.removeNode(Fqn.ROOT);
        this.cache.put("1/2/3/4/5/d", (Object)"key", (Object)"val");
        this.cache.evict(Fqn.fromString((String)"1/2/3/4/5/d"));
        System.out.println("-- checking for 1/2/3/4/5/d");
        this.addDelay();
        try {
            AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        this.cache.getNode("1/2/3/4/5/d");
        AssertJUnit.assertEquals((boolean)true, (boolean)this.loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
        assert (this.exists("1/2/3/4/5/d"));
        System.out.println("-- 1/2/3/4/5/d exists");
        this.cache.get("1/2/3/4/5/d", (Object)"key");
        AssertJUnit.assertEquals((boolean)false, (boolean)this.loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
    }

    public void testCacheLoading2() throws Exception {
        Set keys = null;
        this.cache.put("/a/b/c", (Object)"key", (Object)"val");
        keys = this.cache.getNode(Fqn.fromString((String)"/a/b/c")).getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
    }

    public void testExists() throws Exception {
        this.cache.put("/eins/zwei/drei", (Object)"key1", (Object)"val1");
        assert (this.exists("/eins/zwei/drei"));
        assert (this.exists("/eins/zwei/drei", "key1"));
        assert (!this.exists("/eins/zwei/drei", "key2"));
        assert (!this.exists("/uno/due/tre"));
        assert (!this.exists("/une/due/tre", "key1"));
    }

    public void testGetChildren() throws Exception {
        this.cache.put("/d/one", null);
        this.cache.put("/d/two", null);
        this.cache.put("/d/three", null);
        this.cache.getNode("/d");
        Set children = this.cache.getNode("/d").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("one"));
        AssertJUnit.assertTrue((boolean)children.contains("two"));
        AssertJUnit.assertTrue((boolean)children.contains("three"));
    }

    public void testGetChildrenWithEvictionPassivation() throws Exception {
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/b/c/1"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c/2"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c/3"));
        this.cache.evict(Fqn.fromString((String)"/a/b/c"));
        this.cache.evict(Fqn.fromString((String)"/a/b"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.cache.evict(Fqn.fromString((String)"/"));
        this.addDelay();
        Set children = this.cache.getNode("/a/b/c").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c")));
        this.cache.get("/a/b/c/1", (Object)"test");
        this.cache.get("/a/b/c/2", (Object)"test");
        this.cache.get("/a/b/c/3", (Object)"test");
        this.cache.get("/a/b/c", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c/1")));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c/2")));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c/3")));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/b/c")));
    }

    public void testGetChildren2() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren3() {
        try {
            this.cache.put("/1", null);
            this.cache.put("a", null);
            Set children = this.cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren4() {
        try {
            if (!this.cache.exists("/a/b/c")) {
                this.cache.put("/a/b/c", null);
            }
            Set children = this.cache.getChildrenNames((Fqn)null);
            AssertJUnit.assertTrue((boolean)children.isEmpty());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren5() {
        try {
            this.cache.put("/a/1", null);
            this.cache.put("/a/2", null);
            this.cache.put("/a/3", null);
            NodeSPI n = this.cache.getNode("/a");
            AssertJUnit.assertNotNull((Object)n);
            Set children = n.getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren6Passivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.cache.getNode("/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        this.cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        this.cache.get("/a", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren7Passivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.put("/a", (Object)"test", (Object)"test");
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        Object val = this.cache.get("/a", (Object)"test");
        AssertJUnit.assertEquals((String)"attributes weren't loaded", (Object)"test", (Object)val);
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        this.cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren8Passivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        AssertJUnit.assertNull((Object)this.cache.get("/a/1", (Object)"test"));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren9Passivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        this.cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren10Passivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        this.cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)this.cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testRemoveData() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)this.cache.getNode(key).getKeys().size());
        this.cache.getNode(key).clearData();
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)0, (int)keys.size());
        this.cache.removeNode("/x");
        Object val = this.cache.get(key, (Object)"keyA");
        AssertJUnit.assertNull((Object)val);
    }

    public void testRemoveData2Passivation() throws Exception {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.addDelay();
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.getNode(key).clearData();
        this.cache.evict(key);
        this.addDelay();
        keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertFalse((boolean)this.loader.exists(key));
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveData3Passivation() throws Exception {
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        this.cache.evict(key);
        AssertJUnit.assertTrue((boolean)this.loader.exists(key));
        this.cache.getNode(key).clearData();
        keys = this.cache.getNode(key).getKeys();
        AssertJUnit.assertFalse((boolean)this.loader.exists(key));
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveKey() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.cache.remove(key, (Object)"keyA");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNode(key).getKeys().size());
        this.cache.removeNode("/x");
    }

    public void testRemoveKey2() throws CacheException {
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        Object retval = null;
        this.cache.removeNode(NODE);
        retval = this.cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = this.cache.remove(NODE, (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.addDelay();
        retval = this.cache.remove(NODE, (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemoveKey3Passivation() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        Object retval = null;
        this.cache.removeNode(NODE);
        retval = this.cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.cache.evict(NODE);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(NODE));
        AssertJUnit.assertEquals((Object)10, this.loader.get(NODE).get("key"));
        retval = this.cache.remove(NODE, (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        AssertJUnit.assertFalse((boolean)this.loader.exists(NODE));
        this.cache.evict(NODE);
        this.addDelay();
        retval = this.cache.remove(NODE, (Object)"key");
        AssertJUnit.assertFalse((boolean)this.loader.exists(NODE));
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemove() throws Exception {
        String key = "/x/y/z/";
        this.cache.put(key, (Object)"keyA", (Object)"valA");
        this.cache.put(key, (Object)"keyB", (Object)"valB");
        this.cache.put(key, (Object)"keyC", (Object)"valC");
        this.cache.removeNode("/x");
        AssertJUnit.assertNull((Object)this.cache.get(key, (Object)"keyA"));
        this.addDelay();
        Set keys = this.cache.getKeys(key);
        AssertJUnit.assertNull((Object)keys);
        this.cache.removeNode("/x");
    }

    public void testRemoveRoot() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getKeys().size());
        this.cache.put("/1/2/3/4/5", null);
        this.cache.put("uno/due/tre", null);
        this.cache.put("1/2/3/a", null);
        this.cache.put("/eins/zwei/drei", null);
        this.cache.put("/one/two/three", null);
        this.cache.removeNode(Fqn.ROOT);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getRoot().getKeys().size());
    }

    public void testEvictionWithCacheLoaderPassivation() throws Exception {
        this.cache.put("/first/second", (Object)"key1", (Object)"val1");
        this.cache.put("/first/second/third", (Object)"key2", (Object)"val2");
        this.cache.evict(Fqn.fromString((String)"/first/second"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/first/second")));
        assert (this.exists("/first"));
        String val = (String)this.cache.get("/first/second", (Object)"key1");
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/first/second")));
        AssertJUnit.assertEquals((String)"val1", (String)val);
        String val2 = (String)this.cache.get("/first/second/third", (Object)"key2");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/first/second/third")));
        AssertJUnit.assertEquals((String)"val2", (String)val2);
        assert (this.exists("/first/second/third"));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
    }

    public void testEvictionWithCacheLoaderPassivation2() throws Exception {
        this.cache.put("/first/second/third", (Object)"key1", (Object)"val1");
        this.cache.evict(Fqn.fromString((String)"/first/second/third"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/first/second/third")));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
        String val = (String)this.cache.get("/first/second/third", (Object)"key1");
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/first/second/third")));
        AssertJUnit.assertEquals((String)"val1", (String)val);
        assert (this.exists("/first/second/third"));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
    }

    public void testEvictionWithGetChildrenNamesPassivation() throws Exception {
        this.cache.put("/a/1", null);
        this.cache.put("/a/2", null);
        this.cache.put("/a/3", null);
        this.cache.evict(Fqn.fromString((String)"/a/1"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a/1")));
        this.cache.evict(Fqn.fromString((String)"/a/2"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a/2")));
        this.cache.evict(Fqn.fromString((String)"/a/3"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a/3")));
        this.cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        mgr.getTransaction();
        Set children = this.cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfLocksHeld());
        mgr.commit();
    }

    public void testTxPutCommit() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.commit();
        AssertJUnit.assertNotNull((Object)this.cache.getNode("/one/two/three").getKeys());
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get(Fqn.fromString((String)"/one/two/three"), (Object)"key1"));
        mgr.begin();
        this.cache.evict(Fqn.fromString((String)"/one/two/three"));
        this.cache.evict(Fqn.fromString((String)"/one/two/three/four"));
        mgr.commit();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/one/two/three/four")));
        AssertJUnit.assertNotNull((Object)this.cache.getNode("/one/two/three").getKeys());
        Set children = this.cache.getNode("/one").getChildrenNames();
        AssertJUnit.assertEquals((int)1, (int)children.size());
        this.cache.removeNode(Fqn.ROOT);
    }

    public void testTxPutRollback() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        this.cache.removeNode("/one");
        this.addDelay();
        mgr.begin();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.rollback();
        this.addDelay();
        AssertJUnit.assertNull((Object)this.cache.getNode("/one/two/three"));
        assert (this.cache.getNode("/one") == null);
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertFalse((boolean)this.loader.exists(Fqn.fromString((String)"/one/two/three/four")));
    }

    public void testPassivationAndActivation() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/test");
        this.loader.remove(Fqn.fromString((String)"/"));
        this.cache.put(NODE, (Object)"key", (Object)"val");
        AssertJUnit.assertNull((String)"value cannot be passivated yet (only on eviction)", (Object)this.loader.get(NODE));
        this.cache.evict(NODE);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfAttributes());
        Object val = this.loader.get(NODE).get("key");
        AssertJUnit.assertNotNull((String)"value must have been passivated on evict()", val);
        AssertJUnit.assertEquals(val, (Object)"val");
        Object val2 = this.cache.get(NODE, (Object)"key");
        AssertJUnit.assertNotNull((Object)val2);
        AssertJUnit.assertEquals(val, (Object)val2);
        AssertJUnit.assertNull((String)"value should have been deleted from store on activation", (Object)this.loader.get(NODE));
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations();
    }

    public void testBasicOperationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.doTestBasicOperations();
        mgr.commit();
    }

    private void doTestBasicOperations() throws Exception {
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key"}));
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key1"}));
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key3"}));
        this.doPutTests((Fqn<String>)new Fqn((Object[])new String[]{"key2"}));
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key1"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key2"})).size());
        AssertJUnit.assertEquals((int)4, (int)this.loader.get(new Fqn((Object[])new String[]{"key3"})).size());
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key2"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key3"}));
        this.doRemoveTests((Fqn<String>)new Fqn((Object[])new String[]{"key1"}));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertEquals(null, (Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
    }

    private void doPutTests(Fqn<String> fqn) throws Exception {
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"three", (Object)"four");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", this.loader.get(fqn).get("one"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"xxx");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = this.loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"xxx", (Object)oldVal);
        this.addDelay();
        Map map = this.loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"two", map.get("one"));
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        HashMap<String, String> map2 = new HashMap<String, String>(map);
        map2.put("five", "six");
        map2.put("seven", "eight");
        this.loader.put(fqn, map2);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"six", this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        AssertJUnit.assertEquals(map2, (Object)this.loader.get(fqn));
        AssertJUnit.assertEquals((int)4, (int)map2.size());
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
    }

    private void doRemoveTests(Fqn<String> fqn) throws Exception {
        Object oldVal = this.loader.remove(fqn, (Object)"one");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = this.loader.remove(fqn, (Object)"five");
        AssertJUnit.assertEquals((Object)"six", (Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals(null, this.loader.get(fqn).get("one"));
        AssertJUnit.assertEquals(null, this.loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"four", this.loader.get(fqn).get("three"));
        AssertJUnit.assertEquals((Object)"eight", this.loader.get(fqn).get("seven"));
        Map map = this.loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        AssertJUnit.assertEquals((Object)"eight", map.get("seven"));
        AssertJUnit.assertTrue((boolean)this.loader.exists(fqn));
        this.loader.remove(fqn);
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(fqn));
        AssertJUnit.assertTrue((!this.loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x/y")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key0/x")));
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key0/x")) ? 1 : 0) != 0);
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), null);
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)this.loader.exists(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        this.addDelay();
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key0"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key1"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key2"})) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!this.loader.exists(new Fqn((Object[])new String[]{"key3"})) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        this.loader.put(Fqn.fromString((String)"/key0/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.get(Fqn.fromString((String)"/key0/level1")).isEmpty());
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertTrue((boolean)this.loader.get(Fqn.fromString((String)"/key0")).isEmpty());
        this.loader.put(Fqn.fromString((String)"/key0/x/y"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertTrue((boolean)this.loader.get(Fqn.fromString((String)"/key0/x")).isEmpty());
        this.loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertTrue((boolean)this.loader.get(Fqn.fromString((String)"/key0/x")).isEmpty());
        this.loader.remove(new Fqn((Object[])new String[]{"key0"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key0/x")));
        this.loader.put(new Fqn((Object[])new String[]{"key1"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key2"}), (Object)"a", (Object)"b");
        this.loader.put(new Fqn((Object[])new String[]{"key3"}), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        this.loader.put(Fqn.fromString((String)"/key3/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNotNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)this.loader.get(Fqn.fromString((String)"/key3/level1")).isEmpty());
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNull((Object)this.loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key1"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key3"}));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
        this.loader.remove(new Fqn((Object[])new String[]{"key2"}));
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key0"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key1"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key2"})));
        AssertJUnit.assertNull((Object)this.loader.get(new Fqn((Object[])new String[]{"key3"})));
    }

    public void testGetChildrenNames() throws Exception {
        this.checkChildren(new Fqn(), null);
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.loader.put(Fqn.fromString((String)"/key0"), null);
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0"});
        this.loader.put(Fqn.fromString((String)"/key1/x"), null);
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key1"), new String[]{"x"});
        this.loader.remove(Fqn.fromString((String)"/key1/x"));
        this.addDelay();
        this.checkChildren(new Fqn(), new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.checkChildren(Fqn.fromString((String)"/key1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a"), null);
        this.loader.put(Fqn.fromString((String)"/key0/ab"), null);
        this.loader.put(Fqn.fromString((String)"/key0/abc"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc"});
        this.loader.put(Fqn.fromString((String)"/key0/xxx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/xx"), null);
        this.loader.put(Fqn.fromString((String)"/key0/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        this.loader.put(Fqn.fromString((String)"/key0/a/1"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2"), null);
        this.loader.put(Fqn.fromString((String)"/key0/a/2/1"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString((String)"/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        Set set = this.loader.getChildrenNames(fqn);
        if (names != null) {
            AssertJUnit.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                AssertJUnit.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            AssertJUnit.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications();
    }

    public void testModificationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.doTestModifications();
        mgr.commit();
    }

    private void doTestModifications() throws Exception {
        List<Modification> list = this.createUpdates();
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_NODE);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        AssertJUnit.assertEquals(null, (Object)this.loader.get(FQN));
        this.loader.put(FQN, (Object)"one", (Object)"two");
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_DATA);
        mod.setFqn(FQN);
        list.add(mod);
        this.loader.put(list);
        this.addDelay();
        this.checkModifications(list);
    }

    public void testOnePhaseTransaction() throws Exception {
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(null, mods, true);
        this.checkModifications(mods);
    }

    public void testTwoPhaseTransactionPassivation() throws Exception {
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.commit(txnKey);
        this.addDelay();
        this.checkModifications(mods);
    }

    public void testTransactionRollbackPassivation() throws Exception {
        this.loader.remove(Fqn.fromString((String)"/"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        int num = baos.size();
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        this.loader.prepare(txnKey, mods, false);
        this.loader.rollback(txnKey);
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    private List<Modification> createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        mod.setValue((Object)"two");
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"three");
        mod.setValue((Object)"four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_DATA);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List<Modification> list) throws Exception {
        block7: for (int i = 0; i < list.size(); ++i) {
            Modification mod = list.get(i);
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    AssertJUnit.assertEquals((Object)mod.getValue(), this.loader.get(fqn).get(mod.getKey()));
                    continue block7;
                }
                case PUT_DATA: {
                    Map map = mod.getData();
                    for (Object key : map.keySet()) {
                        AssertJUnit.assertEquals(map.get(key), this.loader.get(fqn).get(key));
                    }
                    continue block7;
                }
                case REMOVE_KEY_VALUE: {
                    AssertJUnit.assertEquals(null, this.loader.get(fqn).get(mod.getKey()));
                    continue block7;
                }
                case REMOVE_DATA: {
                    Map map = this.loader.get(fqn);
                    AssertJUnit.assertNotNull((Object)map);
                    AssertJUnit.assertTrue((boolean)map.isEmpty());
                    continue block7;
                }
                case REMOVE_NODE: {
                    AssertJUnit.assertEquals(null, (Object)this.loader.get(fqn));
                    continue block7;
                }
                default: {
                    AssertJUnit.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testNullKeysAndValues() throws Exception {
        this.loader.put(FQN, null, (Object)"x");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"x", this.loader.get(FQN).get(null));
        HashMap<String, String> map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)1, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        this.loader.put(FQN, (Object)"y", null);
        this.addDelay();
        AssertJUnit.assertEquals(null, this.loader.get(FQN).get("y"));
        map = this.loader.get(FQN);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        AssertJUnit.assertEquals(null, map.get("y"));
        this.loader.remove(FQN, null);
        this.addDelay();
        AssertJUnit.assertEquals(null, this.loader.get(FQN).get(null));
        AssertJUnit.assertEquals((int)1, (int)this.loader.get(FQN).size());
        this.loader.remove(FQN, (Object)"y");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)this.loader.get(FQN));
        AssertJUnit.assertNull(this.loader.get(FQN).get("y"));
        AssertJUnit.assertEquals((int)0, (int)this.loader.get(FQN).size());
        map = new HashMap<String, String>();
        map.put(null, null);
        this.loader.put(FQN, map);
        this.addDelay();
        AssertJUnit.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(FQN));
        map = new HashMap();
        map.put("xyz", null);
        map.put(null, "abc");
        this.loader.put(FQN, map);
        this.addDelay();
        AssertJUnit.assertEquals(map, (Object)this.loader.get(FQN));
        this.loader.remove(FQN);
        this.addDelay();
        AssertJUnit.assertNull((Object)this.loader.get(FQN));
    }

    public void testDatabaseNamePassivation() throws Exception {
        this.loader.put(FQN, (Object)"one", (Object)"two");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", this.loader.get(FQN).get("one"));
    }

    public void testLoadAndStore() throws Exception {
        this.loader.remove(Fqn.fromString((String)"/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        this.loader.put(FQN, (Object)1, (Object)c1);
        this.loader.put(FQN, (Object)2, (Object)c2);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        this.loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)StateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        byte[] savedState = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(savedState);
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        this.loader.storeEntireState((ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, this.loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, this.loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)this.loader.get(FQN).size());
    }

    private static class Complex
    implements Serializable {
        private static final long serialVersionUID = 8950692199236424832L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            try {
                Complex x = (Complex)o;
                return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            if (this.nested == null) {
                return super.hashCode();
            }
            return 13 + this.nested.hashCode();
        }
    }
}

