/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.misc.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReplicationQueueTest {
    private static final int COUNT = 10;
    private static final String CONFIG_FILE = "META-INF/pess-repl-async-issue.xml";
    Cache cache;
    Cache cache2;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setUseReplQueue(true);
        this.cache.getConfiguration().setReplQueueMaxElements(10);
        this.cache.start();
        this.cache2 = new DefaultCacheFactory().createCache(this.cache.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, this.cache, this.cache2);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache, this.cache2);
    }

    public void testFailure() throws InterruptedException {
        int i;
        for (i = 0; i < 10; ++i) {
            System.out.println("on put i = " + i);
            this.cache.put("/a/b/c" + i, (Object)"key", (Object)"value");
            AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c" + i, (Object)"key"));
        }
        Thread.sleep(2000L);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertNotNull((String)("on get i = " + i), (Object)this.cache2.get("/a/b/c" + i, (Object)"key"));
        }
    }
}

