/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.statetransfer.CorruptedFileCacheLoader;
import org.jboss.cache.statetransfer.StateTransferTestBase;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class StateTransfer200Test
extends StateTransferTestBase {
    protected String getReplicationVersion() {
        return "2.0.0.GA";
    }

    public void testBuddyBackupExclusion() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, false, false, false, false, true);
        cache1.getConfiguration().setBuddyReplicationConfig(this.getBuddyConfig());
        cache1.start();
        Fqn backup = new Fqn((Object[])new String[]{"_BUDDY_BACKUP_", "test"});
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(backup, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, false, false);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        AssertJUnit.assertNull((String)"_buddy_backup_ not transferred", (Object)cache2.get(backup, (Object)"test"));
        AssertJUnit.assertEquals((String)"Correct age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
    }

    public void testBuddyIntegration() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, false, false, false, false, true);
        cache1.getConfiguration().setBuddyReplicationConfig(this.getBuddyConfig());
        cache1.start();
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_C, (Object)"name", (Object)"JANE");
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, false, false, false, false, true);
        cache2.getConfiguration().setBuddyReplicationConfig(this.getBuddyConfig());
        cache2.start();
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{cache1, cache2});
        Fqn test = BuddyManager.getBackupFqn((Address)cache1.getLocalAddress(), (Fqn)A_B);
        AssertJUnit.assertEquals((String)("/a/b state should have integrated in backup region " + test), (Object)"JOE", (Object)cache2.get(test, (Object)"name"));
        test = BuddyManager.getBackupFqn((Address)cache1.getLocalAddress(), (Fqn)A_C);
        AssertJUnit.assertEquals((String)("/a/c state should have integrated in backup region " + test), (Object)"JANE", (Object)cache2.get(test, (Object)"name"));
    }

    public void testCacheLoaderFailure() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, false, CorruptedFileCacheLoader.class.getName(), false, true, true);
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)"BOB");
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = null;
        try {
            cache2 = this.createCache("cache2", false, false, true, false, false, true);
            cache2.create();
            cache2.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        AssertJUnit.assertFalse((String)"/a/b is not in cache loader ", (boolean)cache2.getCacheLoaderManager().getCacheLoader().exists(A_B));
    }

    public void testLoadEntireStateAfterStart() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, true, true);
        this.createAndActivateRegion(cache1, Fqn.ROOT);
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)"BOB");
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, true, true);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        CacheLoader loader = cache2.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertNull((String)"/a/b transferred to loader against policy", (Object)loader.get(A_B));
        AssertJUnit.assertNull((String)"/a/b name transferred against policy", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/b age transferred against policy", (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/c name transferred against policy", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/c age transferred against policy", (Object)cache2.get(A_C, (Object)"age"));
        this.createAndActivateRegion(cache2, Fqn.ROOT);
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/b", (Object)"JOE", loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/c", (Object)"BOB", loader.get(A_C).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/c", (Object)FORTY, loader.get(A_C).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
    }

    public void testInitialStateTransfer() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, false, false);
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)"BOB");
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, false, false);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
    }

    public void testInitialStateTferWithLoader() throws Exception {
        this.initialStateTferWithLoaderTest(false);
    }

    public void testInitialStateTferWithAsyncLoader() throws Exception {
        this.initialStateTferWithLoaderTest(true);
    }

    protected void initialStateTferWithLoaderTest(boolean asyncLoader) throws Exception {
        this.initialStateTferWithLoaderTest("org.jboss.cache.loader.FileCacheLoader", "org.jboss.cache.loader.FileCacheLoader", asyncLoader);
    }

    public void testPartialStateTransfer() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, true, false);
        this.createAndActivateRegion(cache1, A);
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)"BOB");
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, true, false);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        AssertJUnit.assertNull((String)"/a/b name transferred against policy", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/b age transferred against policy", (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/c name transferred against policy", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/c age transferred against policy", (Object)cache2.get(A_C, (Object)"age"));
        this.createAndActivateRegion(cache2, A_B);
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/c name transferred against policy", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/c age transferred against policy", (Object)cache2.get(A_C, (Object)"age"));
        cache1.put(A_D, (Object)"name", (Object)"JANE");
        AssertJUnit.assertNull((String)"/a/d name transferred against policy", (Object)cache2.get(A_D, (Object)"name"));
        this.createAndActivateRegion(cache2, A_C);
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/d name transferred against policy", (Object)cache2.get(A_D, (Object)"name"));
        this.createAndActivateRegion(cache2, A_D);
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/d", (Object)"JANE", (Object)cache2.get(A_D, (Object)"name"));
        cache1.getRegion(A, false).deactivate();
        this.createAndActivateRegion(cache1, A_B);
        this.createAndActivateRegion(cache1, A_C);
        this.createAndActivateRegion(cache1, A_D);
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache1.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache1.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache1.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache1.get(A_C, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/d", (Object)"JANE", (Object)cache1.get(A_D, (Object)"name"));
    }

    public void testPartialStateTferWithLoader() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, true, true);
        this.createAndActivateRegion(cache1, A);
        cache1.put(A_B, (Object)"name", (Object)"JOE");
        cache1.put(A_B, (Object)"age", (Object)TWENTY);
        cache1.put(A_C, (Object)"name", (Object)"BOB");
        cache1.put(A_C, (Object)"age", (Object)FORTY);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, true, true);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        CacheLoader loader = cache2.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertNull((String)"/a/b transferred to loader against policy", (Object)loader.get(A_B));
        AssertJUnit.assertNull((String)"/a/b name transferred against policy", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/b age transferred against policy", (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/c name transferred against policy", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/c age transferred against policy", (Object)cache2.get(A_C, (Object)"age"));
        this.createAndActivateRegion(cache2, A_B);
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/b", (Object)"JOE", loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertNull((String)"/a/c transferred to loader against policy", (Object)loader.get(A_C));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/c name transferred against policy", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertNull((String)"/a/c age transferred against policy", (Object)cache2.get(A_C, (Object)"age"));
        cache1.put(A_D, (Object)"name", (Object)"JANE");
        AssertJUnit.assertNull((String)"/a/d name transferred against policy", (Object)cache2.get(A_D, (Object)"name"));
        this.createAndActivateRegion(cache2, A_C);
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/b", (Object)"JOE", loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/c", (Object)"BOB", loader.get(A_C).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/c", (Object)FORTY, loader.get(A_C).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
        AssertJUnit.assertNull((String)"/a/d name transferred against policy", (Object)cache2.get(A_D, (Object)"name"));
        this.createAndActivateRegion(cache2, A_D);
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/b", (Object)"JOE", loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/c", (Object)"BOB", loader.get(A_C).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/c", (Object)FORTY, loader.get(A_C).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/d", (Object)"JANE", loader.get(A_D).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache2.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache2.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache2.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache2.get(A_C, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/d", (Object)"JANE", (Object)cache2.get(A_D, (Object)"name"));
        cache1.getRegion(A, false).deactivate();
        this.createAndActivateRegion(cache1, A_B);
        this.createAndActivateRegion(cache1, A_C);
        this.createAndActivateRegion(cache1, A_D);
        loader = cache1.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/b", (Object)"JOE", loader.get(A_B).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/b", (Object)TWENTY, loader.get(A_B).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/c", (Object)"BOB", loader.get(A_C).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect age from loader for /a/c", (Object)FORTY, loader.get(A_C).get("age"));
        AssertJUnit.assertEquals((String)"Incorrect name from loader for /a/d", (Object)"JANE", loader.get(A_D).get("name"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/b", (Object)"JOE", (Object)cache1.get(A_B, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/b", (Object)TWENTY, (Object)cache1.get(A_B, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/c", (Object)"BOB", (Object)cache1.get(A_C, (Object)"name"));
        AssertJUnit.assertEquals((String)"Incorrect age for /a/c", (Object)FORTY, (Object)cache1.get(A_C, (Object)"age"));
        AssertJUnit.assertEquals((String)"Incorrect name for /a/d", (Object)"JANE", (Object)cache1.get(A_D, (Object)"name"));
    }

    public void testPartialStateTferWithClassLoader() throws Exception {
        Thread.currentThread().setContextClassLoader(this.getNotFoundClassLoader());
        CacheSPI<Object, Object> cache1 = this.createCache("cache1", false, true, true, false, false, true);
        ClassLoader cl1 = this.getClassLoader();
        cache1.getRegion(A, true).registerContextClassLoader(cl1);
        this.startCache((Cache)cache1);
        cache1.getRegion(A, true).activate();
        Object ben = this.createBen(cl1);
        cache1.put(A_B, (Object)"person", ben);
        CacheSPI<Object, Object> cache2 = this.createCache("cache2", false, true, true, false, true, true);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cache1, cache2}, 60000L);
        CacheLoader loader = cache2.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertNull((String)"/a/b not transferred to loader", (Object)loader.get(A_B));
        AssertJUnit.assertNull((String)"/a/b not transferred to cache", (Object)cache2.get(A_B, (Object)"person"));
        ClassLoader cl2 = this.getClassLoader();
        Region r = cache2.getRegion(A, true);
        r.registerContextClassLoader(cl2);
        r.activate();
        AssertJUnit.assertEquals((String)"Correct state from loader for /a/b", (String)ben.toString(), (String)this.getUnmarshalled(loader.get(A_B).get("person")).toString());
        AssertJUnit.assertEquals((String)"Correct state from cache for /a/b", (String)ben.toString(), (String)this.getUnmarshalled(cache2.get(A_B, (Object)"person")).toString());
    }

    private Object getUnmarshalled(Object o) throws Exception {
        return o instanceof MarshalledValue ? ((MarshalledValue)o).get() : o;
    }

    public void testStalePersistentState() throws Exception {
        CacheSPI<Object, Object> c1 = this.createCache("1", true, false, true, false);
        c1.put(A, (Object)"K", (Object)"V");
        assert (c1.get(A, (Object)"K").equals("V"));
        CacheLoader l1 = c1.getCacheLoaderManager().getCacheLoader();
        assert (l1 != null);
        assert (l1.exists(A));
        assert (l1.get(A).get("K").equals("V"));
        c1.stop();
        assert (l1.exists(A));
        assert (l1.get(A).get("K").equals("V"));
        CacheSPI<Object, Object> c2 = this.createCache("2", true, false, true, false);
        c2.put(B, (Object)"K", (Object)"V");
        c1.start();
        assert (c1.get(B, (Object)"K").equals("V"));
        assert (c1.get(A, (Object)"K") == null);
        assert (!l1.exists(A));
    }

    private Object createBen(ClassLoader loader) throws Exception {
        Class<?> addrClazz = loader.loadClass("org.jboss.cache.marshall.data.Address");
        Method setCity = addrClazz.getMethod("setCity", String.class);
        Method setStreet = addrClazz.getMethod("setStreet", String.class);
        Method setZip = addrClazz.getMethod("setZip", Integer.TYPE);
        Object addr = addrClazz.newInstance();
        setCity.invoke(addr, "San Jose");
        setStreet.invoke(addr, "1007 Home");
        setZip.invoke(addr, 90210);
        Class<?> benClazz = loader.loadClass("org.jboss.cache.marshall.data.Person");
        Method setName = benClazz.getMethod("setName", String.class);
        Method setAddress = benClazz.getMethod("setAddress", addrClazz);
        Object ben = benClazz.newInstance();
        setName.invoke(ben, "Ben");
        setAddress.invoke(ben, addr);
        return ben;
    }

    private BuddyReplicationConfig getBuddyConfig() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element config = doc.createElement("config");
        doc.appendChild(config);
        Element enabled = doc.createElement("buddyReplicationEnabled");
        enabled.appendChild(doc.createTextNode("true"));
        config.appendChild(enabled);
        Element pool = doc.createElement("buddyPoolName");
        pool.appendChild(doc.createTextNode("TEST"));
        config.appendChild(pool);
        return XmlConfigurationParser.parseBuddyReplicationConfig((Element)config);
    }
}

