/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.lock.UpgradeException;
import org.jboss.cache.misc.TestingUtil;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.CachePrinter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class DeadlockTest {
    CacheSPI<String, String> cache = null;
    Exception thread_ex;
    final Fqn NODE = Fqn.fromString((String)"/a/b/c");
    final Fqn PARENT_NODE = Fqn.fromString((String)"/a/b");
    final Fqn FQN1 = this.NODE;
    final Fqn FQN2 = Fqn.fromString((String)"/1/2/3");
    final Log log = LogFactory.getLog(DeadlockTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setStateRetrievalTimeout(10000L);
        this.cache.getConfiguration().setClusterName("test");
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.getConfiguration().setLockParentForChildInsertRemove(true);
        this.cache.getConfiguration().setLockAcquisitionTimeout(3000L);
        this.cache.create();
        this.cache.start();
        this.thread_ex = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
        }
        if (this.thread_ex != null) {
            throw this.thread_ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentUpgrade() throws CacheException, InterruptedException {
        MyThreadTimeout t1 = new MyThreadTimeout("MyThread#1", this.NODE);
        MyThread t2 = new MyThread("MyThread#2", this.NODE);
        this.cache.put(this.NODE, null);
        t1.start();
        t2.start();
        TestingUtil.sleepThread(5000L);
        MyThread myThread = t1;
        synchronized (myThread) {
            t1.notify();
        }
        TestingUtil.sleepThread(5000L);
        myThread = t2;
        synchronized (myThread) {
            t2.notify();
        }
        t1.join();
        t2.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutDeadlock() throws CacheException, InterruptedException {
        MyPutterTimeout t1 = new MyPutterTimeout("MyPutter#1", this.FQN1, this.FQN2);
        MyPutter t2 = new MyPutter("MyPutter#2", this.FQN2, this.FQN1);
        this.cache.put(this.FQN1, null);
        this.cache.put(this.FQN2, null);
        t1.start();
        t2.start();
        TestingUtil.sleepThread(1000L);
        MyPutter myPutter = t1;
        synchronized (myPutter) {
            t1.notify();
        }
        TestingUtil.sleepThread(1000L);
        myPutter = t2;
        synchronized (myPutter) {
            t2.notify();
        }
        t1.join();
        t2.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreThanOneUpgrader() throws Exception {
        int NUM = 2;
        Object lock = new Object();
        this.cache.put(this.NODE, (Object)"bla", (Object)"blo");
        MyUpgrader[] upgraders = new MyUpgrader[2];
        for (int i = 0; i < upgraders.length; ++i) {
            upgraders[i] = new MyUpgrader("Upgrader#" + i, this.NODE, lock);
            upgraders[i].start();
        }
        TestingUtil.sleepThread(1000L);
        DeadlockTest.log("locks: " + CachePrinter.printCacheLockingInfo(this.cache));
        Object i = lock;
        synchronized (i) {
            lock.notifyAll();
        }
        for (MyUpgrader upgrader : upgraders) {
            upgrader.join();
        }
    }

    public void testPutsAndRemovesOnParentAndChildNodes() throws InterruptedException {
        ContinuousPutter putter = new ContinuousPutter("Putter", this.NODE);
        ContinuousRemover remover = new ContinuousRemover("Remover", this.PARENT_NODE);
        putter.start();
        remover.start();
        TestingUtil.sleepThread(5000L);
        DeadlockTest.log("stopping Putter");
        putter.looping = false;
        DeadlockTest.log("stopping Remover");
        remover.looping = false;
        putter.join();
        remover.join();
    }

    public void testPutsAndRemovesOnParentAndChildNodesReversed() throws InterruptedException {
        ContinuousPutter putter = new ContinuousPutter("Putter", this.PARENT_NODE);
        ContinuousRemover remover = new ContinuousRemover("Remover", this.NODE);
        putter.start();
        remover.start();
        TestingUtil.sleepThread(5000L);
        DeadlockTest.log("stopping Putter");
        putter.looping = false;
        DeadlockTest.log("stopping Remover");
        remover.looping = false;
        putter.join();
        remover.join();
    }

    public void testPutsAndRemovesOnSameNode() throws InterruptedException {
        ContinuousPutter putter = new ContinuousPutter("Putter", this.NODE);
        ContinuousRemover remover = new ContinuousRemover("Remover", this.NODE);
        putter.start();
        remover.start();
        TestingUtil.sleepThread(5000L);
        DeadlockTest.log("stopping Putter");
        putter.looping = false;
        DeadlockTest.log("stopping Remover");
        remover.looping = false;
        putter.join();
        remover.join();
    }

    private static long random(long range) {
        return (long)(Math.random() * 100000.0 % (double)range) + 1L;
    }

    private static void log(String msg) {
        System.out.println(Thread.currentThread().getName() + ": " + msg);
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        return mgr;
    }

    class MyPutterTimeout
    extends MyPutter {
        public MyPutterTimeout(String name, Fqn fqn1, Fqn fqn2) {
            super(name, fqn1, fqn2);
        }

        protected void _run() throws Exception {
            try {
                super._run();
            }
            catch (TimeoutException timeoutEx) {
                DeadlockTest.log("received TimeoutException as expected");
                this.tm.rollback();
                DeadlockTest.log("rolled back TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            }
        }
    }

    class MyPutter
    extends GenericThread {
        Fqn fqn1;
        Fqn fqn2;

        public MyPutter(String name, Fqn fqn1, Fqn fqn2) {
            super(name);
            this.fqn1 = fqn1;
            this.fqn2 = fqn2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _run() throws Exception {
            this.tm = DeadlockTest.this.startTransaction();
            DeadlockTest.log("put(" + this.fqn1 + ")");
            DeadlockTest.this.cache.put(this.fqn1, (Object)"key", (Object)"val");
            DeadlockTest.log("done, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            MyPutter myPutter = this;
            synchronized (myPutter) {
                this.wait();
            }
            DeadlockTest.log("put(" + this.fqn2 + ")");
            DeadlockTest.this.cache.put(this.fqn2, (Object)"key", (Object)"val");
            DeadlockTest.log("done, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            this.tm.commit();
            DeadlockTest.log("committed TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
        }
    }

    class MyThreadTimeout
    extends MyThread {
        public MyThreadTimeout(String name, Fqn fqn) {
            super(name, fqn);
        }

        protected void _run() throws Exception {
            try {
                super._run();
            }
            catch (UpgradeException upgradeEx) {
                DeadlockTest.log("received UpgradeException as expected");
                this.tm.rollback();
                DeadlockTest.log("rolled back TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            }
            catch (TimeoutException timeoutEx) {
                DeadlockTest.log("received TimeoutException as expected");
                this.tm.rollback();
                DeadlockTest.log("rolled back TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            }
        }
    }

    class MyUpgrader
    extends MyThread {
        Object lock;

        public MyUpgrader(String name, Fqn fqn) {
            super(name, fqn);
        }

        public MyUpgrader(String name, Fqn fqn, Object lock) {
            super(name, fqn);
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _run() throws Exception {
            this.tm = DeadlockTest.this.startTransaction();
            try {
                DeadlockTest.log("get(" + this.fqn + ")");
                DeadlockTest.this.cache.get(this.fqn, (Object)"bla");
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
                DeadlockTest.log("put(" + this.fqn + ")");
                DeadlockTest.this.cache.put(this.fqn, (Object)"key", (Object)"val");
                DeadlockTest.log("done, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
                this.tm.commit();
                DeadlockTest.log("committed TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            }
            catch (UpgradeException upge) {
                DeadlockTest.log("Exception upgrading lock");
                this.tm.rollback();
            }
        }
    }

    class MyThread
    extends GenericThread {
        Fqn fqn;

        public MyThread(String name, Fqn fqn) {
            super(name);
            this.fqn = fqn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _run() throws Exception {
            this.tm = DeadlockTest.this.startTransaction();
            DeadlockTest.log("get(" + this.fqn + ")");
            DeadlockTest.this.cache.get(this.fqn, (Object)"bla");
            DeadlockTest.log("done, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            MyThread myThread = this;
            synchronized (myThread) {
                this.wait();
            }
            DeadlockTest.log("put(" + this.fqn + ")");
            DeadlockTest.this.cache.put(this.fqn, (Object)"key", (Object)"val");
            DeadlockTest.log("done, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
            this.tm.commit();
            DeadlockTest.log("committed TX, locks: " + CachePrinter.printCacheLockingInfo(DeadlockTest.this.cache));
        }
    }

    class ContinuousPutter
    extends GenericThread {
        Fqn fqn;

        public ContinuousPutter(String name, Fqn fqn) {
            super(name);
            this.fqn = fqn;
        }

        protected void _run() throws Exception {
            while (DeadlockTest.this.thread_ex == null && this.looping) {
                try {
                    if (ContinuousPutter.interrupted()) break;
                    this.tm = DeadlockTest.this.startTransaction();
                    DeadlockTest.log("put(" + this.fqn + ")");
                    DeadlockTest.this.cache.put(this.fqn, (Object)"foo", (Object)"bar");
                    ContinuousPutter.sleep(DeadlockTest.random(20L));
                    this.tm.commit();
                }
                catch (InterruptedException interrupted) {
                    this.tm.rollback();
                    break;
                }
                catch (Exception ex) {
                    this.tm.rollback();
                    throw ex;
                }
            }
        }
    }

    class ContinuousRemover
    extends GenericThread {
        Fqn fqn;

        public ContinuousRemover(String name, Fqn fqn) {
            super(name);
            this.fqn = fqn;
        }

        protected void _run() throws Exception {
            while (DeadlockTest.this.thread_ex == null && this.looping) {
                try {
                    if (ContinuousRemover.interrupted()) break;
                    this.tm = DeadlockTest.this.startTransaction();
                    DeadlockTest.log("remove(" + this.fqn + ")");
                    DeadlockTest.this.cache.removeNode(this.fqn);
                    ContinuousRemover.sleep(DeadlockTest.random(20L));
                    this.tm.commit();
                }
                catch (InterruptedException interrupted) {
                    this.tm.rollback();
                    break;
                }
                catch (Exception ex) {
                    this.tm.rollback();
                    throw ex;
                }
            }
        }
    }

    class GenericThread
    extends Thread {
        protected TransactionManager tm;
        protected boolean looping;

        public GenericThread() {
            this.looping = true;
        }

        public GenericThread(String name) {
            super(name);
            this.looping = true;
        }

        public void setLooping(boolean looping) {
            this.looping = looping;
        }

        public void run() {
            block3: {
                try {
                    this._run();
                }
                catch (Exception t) {
                    System.out.println(this.getName() + ": " + t);
                    if (DeadlockTest.this.thread_ex != null) break block3;
                    DeadlockTest.this.thread_ex = t;
                }
            }
            if (DeadlockTest.this.log.isTraceEnabled()) {
                DeadlockTest.this.log.trace((Object)("Thread " + this.getName() + " terminated"));
            }
        }

        protected void _run() throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

