/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class UnicastEnableToTest
extends TestCase {
    JChannel channel = null;
    JChannel channel2 = null;

    public UnicastEnableToTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel("udp.xml");
        this.channel.connect("demo-group");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.channel2 != null) {
            this.channel2.close();
            this.channel2 = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void testUnicastMessageToUnknownMember() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 8976);
        System.out.println("sending message to non-existing destination " + addr);
        try {
            this.channel.send(new Message((Address)addr, null, (Serializable)((Object)"Hello world")));
            UnicastEnableToTest.fail((String)("we should not get here; sending of message to " + addr + " should have failed"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("received exception as expected");
        }
    }

    public void testUnicastMessageToExistingMember() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        MyReceiver receiver = new MyReceiver();
        this.channel2.setReceiver(receiver);
        Address dest = this.channel2.getLocalAddress();
        this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
        Util.sleep(500L);
        List list = receiver.getMsgs();
        System.out.println("channel2 received the following msgs: " + list);
        UnicastEnableToTest.assertEquals((int)1, (int)list.size());
        receiver.reset();
    }

    public void testUnicastMessageToLeftMember() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        Address dest = this.channel2.getLocalAddress();
        this.channel2.close();
        Util.sleep(100L);
        try {
            this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
            UnicastEnableToTest.fail((String)("we should not come here as message to previous member " + dest + " should throw exception"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("got an exception, as expected");
        }
    }

    public void testUnicastMessageToLeftMemberWithEnableUnicastToEvent() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        Address dest = this.channel2.getLocalAddress();
        this.channel2.close();
        Util.sleep(100L);
        this.channel.down(new Event(67, dest));
        this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{UnicastEnableToTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        List<Message> msgs = new LinkedList<Message>();

        private MyReceiver() {
        }

        public void receive(Message msg) {
            this.msgs.add(msg);
        }

        List getMsgs() {
            return this.msgs;
        }

        void reset() {
            this.msgs.clear();
        }
    }
}

