/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationRegistry;
import org.jboss.cache.config.XmlParsingConfigurationRegistry;
import org.jgroups.ChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManagerImpl
implements CacheManager {
    private ConfigurationRegistry configRegistry;
    private boolean configRegistryInjected;
    private Map<String, Cache<Object, Object>> caches = new HashMap<String, Cache<Object, Object>>();
    private Map<String, Integer> checkouts = new HashMap<String, Integer>();
    private ChannelFactory channelFactory;
    private boolean started;

    public CacheManagerImpl() {
    }

    public CacheManagerImpl(ConfigurationRegistry configRegistry, ChannelFactory factory) {
        this.configRegistry = configRegistry;
        this.configRegistryInjected = true;
        this.channelFactory = factory;
    }

    public CacheManagerImpl(String configFileName, ChannelFactory factory) {
        this.configRegistry = new XmlParsingConfigurationRegistry(configFileName);
        this.channelFactory = factory;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getConfigurationNames() {
        Map<String, Cache<Object, Object>> map = this.caches;
        synchronized (map) {
            Set<Object> configNames = this.configRegistry == null ? new HashSet() : this.configRegistry.getConfigurationNames();
            configNames.addAll(this.getCacheNames());
            return configNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getCacheNames() {
        Map<String, Cache<Object, Object>> map = this.caches;
        synchronized (map) {
            return new HashSet<String>(this.caches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache<Object, Object> getCache(String configName, boolean create) throws Exception {
        Cache<Object, Object> cache = null;
        Map<String, Cache<Object, Object>> map = this.caches;
        synchronized (map) {
            cache = this.caches.get(configName);
            if (cache == null && create) {
                Configuration config = this.configRegistry.getConfiguration(configName);
                if (this.channelFactory != null && config.getMultiplexerStack() != null) {
                    config.getRuntimeConfig().setMuxChannelFactory(this.channelFactory);
                }
                cache = this.createCache(config);
                this.registerCache(cache, configName);
            } else if (cache != null) {
                this.incrementCheckout(configName);
            }
        }
        return cache;
    }

    protected Cache<Object, Object> createCache(Configuration config) {
        return new DefaultCacheFactory().createCache(config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCache(String configName) {
        Map<String, Cache<Object, Object>> map = this.caches;
        synchronized (map) {
            if (!this.caches.containsKey(configName)) {
                throw new IllegalStateException(configName + " not registered");
            }
            if (this.decrementCheckout(configName) == 0) {
                Cache<Object, Object> cache = this.caches.remove(configName);
                this.destroyCache(cache);
            }
        }
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return this.configRegistry;
    }

    public void setConfigurationRegistry(ConfigurationRegistry configRegistry) {
        this.configRegistry = configRegistry;
        this.configRegistryInjected = true;
    }

    public void setChannelFactory(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCache(Cache<Object, Object> cache, String configName) {
        Map<String, Cache<Object, Object>> map = this.caches;
        synchronized (map) {
            if (this.caches.containsKey(configName)) {
                throw new IllegalStateException(configName + " already registered");
            }
            this.caches.put(configName, cache);
            this.incrementCheckout(configName);
        }
    }

    public void start() throws Exception {
        if (!this.started) {
            if (this.configRegistry == null) {
                throw new IllegalStateException("Must configure a ConfigurationRegistry before calling start()");
            }
            if (this.channelFactory == null) {
                throw new IllegalStateException("Must provide a ChannelFactory before calling start()");
            }
            if (!this.configRegistryInjected) {
                ((XmlParsingConfigurationRegistry)this.configRegistry).start();
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.started) {
            Map<String, Cache<Object, Object>> map = this.caches;
            synchronized (map) {
                Iterator<Map.Entry<String, Cache<Object, Object>>> it = this.caches.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Cache<Object, Object>> entry = it.next();
                    this.destroyCache(entry.getValue());
                    it.remove();
                }
                this.caches.clear();
                this.checkouts.clear();
            }
            if (!this.configRegistryInjected) {
                ((XmlParsingConfigurationRegistry)this.configRegistry).stop();
            }
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementCheckout(String configName) {
        Map<String, Integer> map = this.checkouts;
        synchronized (map) {
            Integer count = this.checkouts.get(configName);
            if (count == null) {
                count = new Integer(0);
            }
            Integer newVal = new Integer(count + 1);
            this.checkouts.put(configName, newVal);
            return newVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementCheckout(String configName) {
        Map<String, Integer> map = this.checkouts;
        synchronized (map) {
            Integer count = this.checkouts.get(configName);
            if (count == null || count < 1) {
                throw new IllegalStateException("invalid count of " + count + " for " + configName);
            }
            Integer newVal = new Integer(count - 1);
            this.checkouts.put(configName, newVal);
            return newVal;
        }
    }

    private void destroyCache(Cache<Object, Object> cache) {
        if (cache.getCacheStatus() == CacheStatus.STARTED) {
            cache.stop();
        }
        if (cache.getCacheStatus() != CacheStatus.DESTROYED && cache.getCacheStatus() != CacheStatus.INSTANTIATED) {
            cache.destroy();
        }
    }
}

