/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationRegistry;
import org.jboss.cache.factories.CacheConfigsXmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParsingConfigurationRegistry
implements ConfigurationRegistry {
    private CacheConfigsXmlParser parser;
    private String configResource;
    private Map<String, Configuration> configs = new Hashtable<String, Configuration>();
    private boolean started;

    public XmlParsingConfigurationRegistry(String configResource) {
        this.parser = new CacheConfigsXmlParser();
        this.configResource = configResource;
    }

    public void start() throws Exception {
        if (!this.started) {
            this.configs.putAll(this.parser.parseConfigs(this.configResource));
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.started) {
            Map<String, Configuration> map = this.configs;
            synchronized (map) {
                this.configs.clear();
            }
            this.started = false;
        }
    }

    public String getConfigResource() {
        return this.configResource;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return new HashSet<String>(this.configs.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConfiguration(String configName, Configuration config) throws CloneNotSupportedException {
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            if (this.configs.containsKey(configName)) {
                throw new IllegalStateException(configName + " already registered");
            }
            this.configs.put(configName, config.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConfiguration(String configName) {
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            if (this.configs.remove(configName) == null) {
                throw new IllegalStateException(configName + " not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration(String configName) {
        Configuration config = null;
        Map<String, Configuration> map = this.configs;
        synchronized (map) {
            config = this.configs.get(configName);
        }
        if (config == null) {
            throw new IllegalArgumentException("unknown config " + configName);
        }
        try {
            return config.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone configuration " + configName, e);
        }
    }
}

