/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.ActivationInterceptorMBean;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationInterceptor
extends CacheLoaderInterceptor
implements ActivationInterceptorMBean {
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txActivations = new HashMap();
    private long m_activations = 0L;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public ActivationInterceptor() {
        this.initLogger();
        this.isActivation = true;
        this.useCacheStore = false;
    }

    @Override
    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handleRemoveDataMethod(ctx, tx, fqn, createUndoOps);
        if (this.trace) {
            this.log.trace((Object)"This is a remove data operation; removing the data from the loader, no activation processing needed.");
        }
        this.loader.removeData(fqn);
        return returnValue;
    }

    @Override
    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handleRemoveNodeMethod(ctx, tx, fqn, createUndoOps);
        if (this.trace) {
            this.log.trace((Object)"This is a remove operation; removing the node from the loader, no activation processing needed.");
        }
        this.loader.remove(fqn);
        return returnValue;
    }

    @Override
    protected Object handlePrintMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = super.handlePrintMethod(ctx, fqn);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleReleaseAllLocksMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = super.handleReleaseAllLocksMethod(ctx, fqn);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleGetChildrenNamesMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = super.handleGetChildrenNamesMethod(ctx, fqn);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleGetKeysMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = super.handleGetKeysMethod(ctx, fqn);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        Object returnValue = super.handleGetNodeMethod(ctx, fqn);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        Object returnValue = super.handleGetKeyValueMethod(ctx, fqn, key, sendNodeEvent);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleAddChildMethod(InvocationContext ctx, GlobalTransaction tx, Fqn parentFqn, Object childName, Node cn, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handleAddChildMethod(ctx, tx, parentFqn, childName, cn, createUndoOps);
        this.removeNodeFromCacheLoader(ctx, parentFqn);
        return returnValue;
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        Object returnValue = super.handlePutForExternalReadMethod(ctx, tx, fqn, key, value);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handlePutDataMethod(ctx, tx, fqn, data, createUndoOps);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handlePutKeyValueMethod(ctx, gtx, fqn, key, value, createUndoOps);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        Object returnValue = super.handleRemoveKeyMethod(ctx, tx, fqn, key, createUndoOps);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        Object returnValue = super.handlePutDataEraseMethod(ctx, gt, fqn, newData, createUndoOps, eraseContents);
        this.removeNodeFromCacheLoader(ctx, fqn);
        return returnValue;
    }

    private void removeNodeFromCacheLoader(InvocationContext ctx, Fqn fqn) throws Throwable {
        NodeSPI n = this.peekNode(ctx, fqn, false, true, false);
        if (n != null && n.isDataLoaded() && this.loader.exists(fqn)) {
            if (!n.getChildrenDirect().isEmpty()) {
                if (this.allInitialized(n)) {
                    this.log.debug((Object)"children all initialized");
                    this.remove(ctx, fqn);
                }
            } else if (this.loaderNoChildren(fqn)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("no children " + n));
                }
                this.remove(ctx, fqn);
            }
        }
    }

    @Override
    protected Object handleOptimisticPrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            this.prepareCacheLoader(ctx);
        }
        return retval;
    }

    private boolean inTransaction() throws SystemException {
        return this.tx_mgr != null && this.tx_mgr.getTransaction() != null;
    }

    @Override
    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        Object retval = this.nextInterceptor(ctx);
        if (this.inTransaction()) {
            this.prepareCacheLoader(ctx);
        }
        return retval;
    }

    private void remove(InvocationContext ctx, Fqn fqn) throws Exception {
        this.cache.getNotifier().notifyNodeActivated(fqn, true, Collections.emptyMap(), ctx);
        this.loader.remove(fqn);
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_activations;
        }
    }

    private boolean allInitialized(NodeSPI<?, ?> n) {
        if (!n.isChildrenLoaded()) {
            return false;
        }
        for (NodeSPI<?, ?> child : n.getChildrenDirect()) {
            if (child.isDataLoaded()) continue;
            return false;
        }
        return true;
    }

    private boolean loaderNoChildren(Fqn fqn) {
        try {
            Set<?> children_names = this.loader.getChildrenNames(fqn);
            return children_names == null;
        }
        catch (Exception e) {
            this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
            return false;
        }
    }

    @Override
    public long getActivations() {
        return this.m_activations;
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.m_activations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        Map<String, Object> retval = super.dumpStatistics();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("Activations", this.m_activations);
        return retval;
    }

    private void prepareCacheLoader(InvocationContext ctx) throws Exception {
        int txActs = 0;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List<MethodCall> modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        for (MethodCall methodCall : modifications) {
            Method method = methodCall.getMethod();
            if (method == null) {
                throw new Exception("method call has no method: " + (Object)((Object)methodCall));
            }
            Object[] args = methodCall.getArgs();
            switch (methodCall.getMethodId()) {
                case 5: {
                    Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, (Fqn)args[1]);
                    cache_loader_modifications.add(mod);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    NodeSPI n;
                    Fqn fqn = (Fqn)args[1];
                    if (fqn == null || this.peekNode(ctx, fqn, false, false, false) == null || !this.loader.exists(fqn) || (n = this.peekNode(ctx, fqn, false, true, false)) == null || !n.isDataLoaded()) break;
                    if (!n.getChildrenDirect().isEmpty() && this.allInitialized(n)) {
                        this.addRemoveMod(ctx, cache_loader_modifications, fqn, n.getDataDirect());
                        ++txActs;
                        break;
                    }
                    if (!this.loaderNoChildren(fqn)) break;
                    this.addRemoveMod(ctx, cache_loader_modifications, fqn, n.getDataDirect());
                    ++txActs;
                }
            }
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, false);
            if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled() && txActs > 0) {
                this.m_txActivations.put(gtx, txActs);
            }
        }
    }

    private void addRemoveMod(InvocationContext ctx, List l, Fqn fqn, Map data) {
        Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, fqn);
        l.add(mod);
        this.cache.getNotifier().notifyNodeActivated(fqn, false, data, ctx);
    }
}

