/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.CacheLoaderInterceptorMBean;
import org.jboss.cache.interceptors.MethodDispacherInterceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheLoaderInterceptor
extends MethodDispacherInterceptor
implements CacheLoaderInterceptorMBean {
    private long m_cacheLoads = 0L;
    private long m_cacheMisses = 0L;
    private TransactionTable txTable = null;
    protected boolean isActivation = false;
    protected CacheLoader loader;
    protected CacheLoaderManager clm;
    protected boolean usingOptimisticInvalidation = false;
    protected boolean useCacheStore = true;

    public CacheLoaderInterceptor() {
        this.initLogger();
    }

    @Inject
    protected void injectDependencies(TransactionTable txTable, CacheLoaderManager clm, Configuration configuration) {
        this.txTable = txTable;
        this.clm = clm;
        Configuration.CacheMode mode = configuration.getCacheMode();
        this.usingOptimisticInvalidation = configuration.isNodeLockingOptimistic() && mode.isInvalidation();
    }

    @Start
    protected void startInterceptor() {
        this.loader = this.clm.getCacheLoader();
    }

    @Override
    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, true, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, true, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, Object value) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, key, false, this.useCacheStore, !this.useCacheStore, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, key, false, this.useCacheStore, !this.useCacheStore, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        if (from != null) {
            if (to != null) {
                this.loadIfNeeded(ctx, to, null, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, true, false);
            }
            this.loadIfNeeded(ctx, from, null, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), true, true, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleAddChildMethod(InvocationContext ctx, GlobalTransaction tx, Fqn parentFqn, Object childName, Node cn, boolean createUndoOps) throws Throwable {
        if (parentFqn != null) {
            this.loadIfNeeded(ctx, parentFqn, null, false, false, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetKeyValueMethod(InvocationContext ctx, Fqn fqn, Object key, boolean sendNodeEvent) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, key, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetNodeMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, !this.usingOptimisticInvalidation);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetChildrenNamesMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, true);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleReleaseAllLocksMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handlePrintMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetKeysMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, true, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleGetDataMapMethod(InvocationContext ctx, Fqn fqn) throws Throwable {
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, true, false, true, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction globalTransaction) throws Throwable {
        List<Fqn> list;
        if (this.trace) {
            this.log.trace((Object)"Removing temporarily created nodes from treecache");
        }
        if ((list = this.getTransactionEntry(ctx).getDummyNodesCreatedByCacheLoader()) != null && list.size() > 0) {
            ListIterator<Fqn> i = list.listIterator(list.size());
            while (i.hasPrevious()) {
                Fqn fqn = i.previous();
                try {
                    this.cache.evict(fqn, false);
                }
                catch (CacheException e) {
                    if (!this.trace) continue;
                    this.log.trace((Object)("Unable to evict node " + fqn), (Throwable)e);
                }
            }
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        if (this.cache.getConfiguration().isNodeLockingOptimistic() && fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        if (fqn != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, fqn, key, false, false, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    @Override
    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        if (fqn != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, fqn, null, false, true, false, ctx.getMethodCall(), this.getTransactionEntry(ctx), false, false, false);
        }
        return this.nextInterceptor(ctx);
    }

    private void loadIfNeeded(InvocationContext ctx, Fqn fqn, Object key, boolean allKeys, boolean initNode, boolean acquireLock, MethodCall m, TransactionEntry entry, boolean recursive, boolean isMove, boolean bypassLoadingData) throws Throwable {
        NodeSPI n = this.peekNode(ctx, fqn, false, true, true);
        boolean mustLoad = this.mustLoad(n, key, allKeys);
        if (this.trace) {
            this.log.trace((Object)("load element " + fqn + " mustLoad=" + mustLoad));
        }
        if (mustLoad) {
            if (initNode) {
                n = this.createTempNode(fqn, entry);
            }
            if (acquireLock) {
                this.lock(fqn, NodeLock.LockType.WRITE, false);
            }
            if (!this.wasRemovedInTx(fqn, ctx.getGlobalTransaction())) {
                if (bypassLoadingData) {
                    if (n == null && this.loader.exists(fqn)) {
                        n = this.createTempNode(fqn, entry);
                    }
                } else {
                    n = this.loadNode(ctx, fqn, n, entry);
                }
            }
        }
        if (recursive || m.getMethodId() == 23) {
            this.loadChildren(fqn, n, recursive, isMove);
        }
    }

    private void loadChildren(Fqn fqn, NodeSPI node, boolean recursive, boolean isMove) throws Throwable {
        if (node != null && node.isChildrenLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"Children already loaded!");
            }
            return;
        }
        Set<?> children_names = this.loader.getChildrenNames(fqn);
        if (this.trace) {
            this.log.trace((Object)("load children " + fqn + " children=" + children_names));
        }
        if (children_names == null) {
            if (node != null) {
                if (this.useCacheStore) {
                    node.removeChildrenDirect();
                }
                node.setChildrenLoaded(true);
            }
            return;
        }
        if (node == null) {
            node = this.createNodes(fqn, null);
        }
        for (Object name : children_names) {
            Fqn<Object> child_fqn = new Fqn<Object>(name);
            NodeSPI child = node.addChildDirect(child_fqn);
            if ((isMove || this.isActivation) && recursive) {
                child.setInternalState(this.loader.get(child.getFqn()));
                child.setDataLoaded(true);
            }
            if (!recursive) continue;
            this.loadChildren(child.getFqn(), child, true, isMove);
        }
        this.lock(fqn, recursive ? NodeLock.LockType.WRITE : NodeLock.LockType.READ, true);
        node.setChildrenLoaded(true);
    }

    private boolean mustLoad(NodeSPI n, Object key, boolean allKeys) {
        if (n == null) {
            if (this.trace) {
                this.log.trace((Object)"must load, node null");
            }
            return true;
        }
        if (!n.isValid() && this.cache.getConfiguration().isNodeLockingOptimistic()) {
            if (this.trace) {
                this.log.trace((Object)"loading again from cache loader since in-memory node is marked as invalid");
            }
            return true;
        }
        if (!allKeys) {
            if (key == null) {
                if (this.trace) {
                    this.log.trace((Object)"don't load, key requested is null");
                }
                return false;
            }
            if (n.getKeysDirect().contains(key)) {
                if (this.trace) {
                    this.log.trace((Object)"don't load, already have necessary key in memory");
                }
                return false;
            }
        }
        if (!n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"must Load, uninitialized");
            }
            return true;
        }
        return false;
    }

    @Override
    public long getCacheLoaderLoads() {
        return this.m_cacheLoads;
    }

    @Override
    public long getCacheLoaderMisses() {
        return this.m_cacheMisses;
    }

    @Override
    public void resetStatistics() {
        this.m_cacheLoads = 0L;
        this.m_cacheMisses = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderLoads", this.m_cacheLoads);
        retval.put("CacheLoaderMisses", this.m_cacheMisses);
        return retval;
    }

    protected void lock(Fqn fqn, NodeLock.LockType lock_type, boolean recursive) throws Throwable {
        if (this.configuration.isNodeLockingOptimistic()) {
            return;
        }
        MethodCall m = MethodCallFactory.create(33, new Object[]{fqn, lock_type, recursive});
        this.cache.getInterceptorChain().get(0).invoke(InvocationContext.fromMethodCall(m));
    }

    private TransactionEntry getTransactionEntry(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx != null) {
            return this.txTable.get(gtx);
        }
        return null;
    }

    private boolean wasRemovedInTx(Fqn fqn, GlobalTransaction t) {
        if (t == null) {
            return false;
        }
        TransactionEntry entry = this.txTable.get(t);
        for (MethodCall m : entry.getCacheLoaderModifications()) {
            if (m.getMethodId() != 5 || !fqn.isChildOrEquals((Fqn)m.getArgs()[1])) continue;
            return true;
        }
        return false;
    }

    private NodeSPI loadNode(InvocationContext ctx, Fqn fqn, NodeSPI n, TransactionEntry entry) throws Exception {
        Map nodeData;
        if (this.trace) {
            this.log.trace((Object)("loadNode " + fqn));
        }
        if ((nodeData = this.loadData(fqn)) != null) {
            if (this.trace) {
                this.log.trace((Object)"Node data is not null, loading");
            }
            this.cache.getNotifier().notifyNodeLoaded(fqn, true, Collections.emptyMap(), ctx);
            if (this.isActivation) {
                this.cache.getNotifier().notifyNodeActivated(fqn, true, Collections.emptyMap(), ctx);
            }
            n = this.createNodes(fqn, entry);
            n.setInternalState(nodeData);
            if (this.usingOptimisticInvalidation) {
                n.setValid(true, false);
            }
            this.cache.getNotifier().notifyNodeLoaded(fqn, false, nodeData, ctx);
            if (this.isActivation) {
                this.cache.getNotifier().notifyNodeActivated(fqn, false, nodeData, ctx);
            }
        }
        if (n != null && !n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"Setting dataLoaded to true");
            }
            n.setDataLoaded(true);
        }
        return n;
    }

    private NodeSPI createTempNode(Fqn fqn, TransactionEntry entry) throws Exception {
        NodeSPI n = this.createNodes(fqn, entry);
        n.setDataLoaded(false);
        if (this.trace) {
            this.log.trace((Object)("createTempNode n " + n));
        }
        return n;
    }

    private NodeSPI createNodes(Fqn fqn, TransactionEntry entry) throws Exception {
        Fqn<Object> tmp_fqn = Fqn.ROOT;
        int size = fqn.size();
        NodeSPI n = this.cache.getRoot();
        for (int i = 0; i < size; ++i) {
            boolean last;
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn<Object>(tmp_fqn, child_name);
            NodeSPI child_node = this.findChild(n, child_name);
            boolean bl = last = i == size - 1;
            if (child_node == null) {
                if (last) {
                    child_node = n.addChildDirect(new Fqn<Object>(child_name));
                    child_node.setDataLoaded(true);
                } else {
                    child_node = n.addChildDirect(new Fqn<Object>(child_name));
                    child_node.setDataLoaded(false);
                }
                if (entry != null) {
                    entry.loadUninitialisedNode(tmp_fqn);
                }
            }
            n = child_node;
        }
        return n;
    }

    private NodeSPI findChild(NodeSPI node, Object child_name) {
        Map children = node.getChildrenMapDirect();
        if (children == null) {
            return null;
        }
        return (NodeSPI)children.get(child_name);
    }

    private Map loadData(Fqn fqn) throws Exception {
        boolean nodeExists;
        Map<Object, Object> nodeData = this.loader.get(fqn);
        boolean bl = nodeExists = nodeData != null;
        if (this.trace) {
            this.log.trace((Object)("nodeExists " + nodeExists));
        }
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            if (nodeExists) {
                ++this.m_cacheLoads;
            } else {
                ++this.m_cacheMisses;
            }
        }
        return nodeData;
    }
}

