/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jgroups.Address;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    public ReplicationInterceptor() {
        this.initLogger();
    }

    protected boolean skipMethodCall(InvocationContext ctx) {
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            if (this.trace) {
                this.log.trace((Object)"skip replication");
            }
            return true;
        }
        return false;
    }

    protected Object handleCommitMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        if (this.skipReplciationOfTransactionMethod(ctx)) {
            return this.nextInterceptor(ctx);
        }
        this.replicateCall(ctx, ctx.getMethodCall(), this.configuration.isSyncCommitPhase(), ctx.getOptionOverrides(), true);
        return this.nextInterceptor(ctx);
    }

    protected Object handlePrepareMethod(InvocationContext ctx, GlobalTransaction gtx, List modification, Address coordinator, boolean onePhaseCommit) throws Throwable {
        if (this.skipReplciationOfTransactionMethod(ctx)) {
            return this.nextInterceptor(ctx);
        }
        Object retVal = this.nextInterceptor(ctx);
        this.runPreparePhase(ctx.getMethodCall(), gtx, ctx);
        return retVal;
    }

    protected Object handleRollbackMethod(InvocationContext ctx, GlobalTransaction gtx) throws Throwable {
        if (this.skipReplciationOfTransactionMethod(ctx)) {
            return this.nextInterceptor(ctx);
        }
        if (!ctx.isLocalRollbackOnly()) {
            this.replicateCall(ctx, ctx.getMethodCall(), this.configuration.isSyncRollbackPhase(), ctx.getOptionOverrides());
        }
        return this.nextInterceptor(ctx);
    }

    protected Object handlePutForExternalReadMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value) throws Throwable {
        if (this.isTransactionalAndLocal(ctx)) {
            Object returnValue = this.nextInterceptor(ctx);
            this.cache.getTransactionTable().get(gtx).setForceAsyncReplication(true);
            return returnValue;
        }
        return this.handleCrudMethod(ctx);
    }

    private boolean skipReplciationOfTransactionMethod(InvocationContext ctx) {
        boolean isInitiatedHere;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean bl = isInitiatedHere = gtx != null && !gtx.isRemote();
        if (this.trace) {
            this.log.trace((Object)("isInitiatedHere? " + isInitiatedHere + "; gtx = " + gtx));
        }
        return !this.isTransactionalAndLocal(ctx) || !this.containsModifications(ctx);
    }

    private boolean isTransactionalAndLocal(InvocationContext ctx) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        boolean isInitiatedHere = gtx != null && !gtx.isRemote();
        return isInitiatedHere && ctx.getTransaction() != null;
    }

    protected Object handlePutDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Map data, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutDataEraseMethod(InvocationContext ctx, GlobalTransaction gt, Fqn fqn, Map newData, boolean createUndoOps, boolean eraseContents) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutKeyValueVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutDataEraseVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Map data, boolean createUndoOps, boolean eraseContent, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutDataVersionedMethod(InvocationContext ctx, GlobalTransaction globalTransaction, Fqn fqn, Map map, Boolean createUndoOps, DataVersion dataVersion) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutKeyValueMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handlePutForExternalReadVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, Object value, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveNodeMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveKeyMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, Object key, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveDataMethod(InvocationContext ctx, GlobalTransaction tx, Fqn fqn, boolean createUndoOps) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleDataGravitationCleanupMethod(InvocationContext ctx, Fqn primary, Fqn backup) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleMoveMethod(InvocationContext ctx, Fqn from, Fqn to) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveNodeVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveKeyVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, Object key, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    protected Object handleRemoveDataVersionedMethod(InvocationContext ctx, GlobalTransaction gtx, Fqn fqn, boolean createUndoOps, DataVersion dv) throws Throwable {
        return this.handleCrudMethod(ctx);
    }

    private Object handleCrudMethod(InvocationContext ctx) throws Throwable {
        Object returnValue = this.nextInterceptor(ctx);
        if (ctx.getTransaction() == null && ctx.isOriginLocal()) {
            MethodCall m = ctx.getMethodCall();
            if (this.trace) {
                this.log.trace((Object)("invoking method " + (Object)((Object)m) + ", members=" + this.cache.getMembers() + ", mode=" + (Object)((Object)this.configuration.getCacheMode()) + ", exclude_self=" + true + ", timeout=" + this.configuration.getSyncReplTimeout()));
            }
            if (!this.isSynchronous(ctx.getOptionOverrides()) || m.getMethodId() == 45) {
                this.replicateCall(ctx, m, false, ctx.getOptionOverrides());
            } else {
                this.replicateCall(ctx, m, true, ctx.getOptionOverrides());
            }
        }
        return returnValue;
    }

    protected void runPreparePhase(MethodCall prepareMethod, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean async;
        boolean bl = async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
        if (this.trace) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async));
        }
        this.replicateCall(ctx, prepareMethod, !async, ctx.getOptionOverrides());
    }
}

