/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class BitEncodedIntegerSet {
    private long encoded = 0L;

    public void add(int i) {
        this.encoded |= 1L << i;
    }

    public void remove(int i) {
        this.encoded &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean contains(int i) {
        return (this.encoded & 1L << i) != 0L;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitEncodedIntegerSet that = (BitEncodedIntegerSet)o;
        return this.encoded == that.encoded;
    }

    public int hashCode() {
        return (int)(this.encoded ^ this.encoded >>> 32);
    }

    public void clear() {
        this.encoded = 0L;
    }

    public boolean isEmpty() {
        return this.encoded == 0L;
    }

    public String toString() {
        return "BitEncodedSet (encoded as: " + Long.toBinaryString(this.encoded) + ")";
    }

    public void addAll(BitEncodedIntegerSet otherSet) {
        this.encoded |= otherSet.encoded;
    }
}

