/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo;

import java.util.Properties;

import javax.naming.Context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * New NewReplicatedAopTest that doesn't use TreeCacheAopTester.
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class ReplicatedNonSerializableTest 
{
   Log log_ = LogFactory.getLog(ReplicatedNonSerializableTest.class);
   PojoCache cache_;
   PojoCache cache1_;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      Properties prop = new Properties();
      prop.put(Context.INITIAL_CONTEXT_FACTORY, "org.jboss.cache.transaction.DummyContextFactory");
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache1_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache_.start();
      cache1_.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
      cache1_.stop();
   }

   public void testDummy()
   {
   }

   /* JBCACHE-770
   public void testNonSeriazable1() throws Exception
   {
      log_.info("testNonSerializable1() ....");
      // First the flag is set to false
      NonSerializableObject nso = new NonSerializableObject();
      nso.setId("2");
      try {
         cache_.attach("/test", nso);
         fail("should fail becuase vo is not Serializable");
      }
      catch (RuntimeException e) {
      }

      // Then we set the flag
      cache_.setMarshallNonSerializable(true);
      cache1_.setMarshallNonSerializable(true);
      cache_.attach("/test", nso);
      NonSerializableObject nso1 = (NonSerializableObject)cache1_.find("/test");
      assertNotNull("nso on remote cache should not be null", nso1);
      assertEquals("VO should be the same", nso, nso1);

   }

   public void testNonSeriazable2() throws Exception
   {
      log_.info("testNonSerializable2() ....");
      // First the flag is set to false
      NonSerializableObject nso = new NonSerializableObject();
      nso.setId("2");

      // Then we set the flag
      cache_.setMarshallNonSerializable(true);
      cache1_.setMarshallNonSerializable(true);
      cache_.attach("/test", nso);
      NonSerializableObject nso1 = (NonSerializableObject)cache1_.find("/test");
      assertNotNull("nso on remote cache should not be null", nso1);
      assertEquals("VO should be the same", nso, nso1);

      nso1 = new NonSerializableObject();
      nso1.setId("4");
      cache1_.attach("/test", nso1);
      nso = (NonSerializableObject)cache_.find("/test");
      assertNotNull("nso on remote cache should not be null", nso);
      assertEquals("VO should be the same", nso, nso1);

   }

*/




}
