/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.test;

/**
 * Test class for PojoCache using annotation. This represents a special resource
 * type that can be declared @Transient. That is, it is neither Replicable nor
 * Serializable.
 *
 * @version $Revision: 3411 $
 */
@org.jboss.cache.pojo.annotation.Replicable
public class Resource
{
   String connection = null;
   String name = null;
// Can turin it on for performance optimization
//   @org.jboss.cache.pojo.annotation.Serializable
   byte[] bin = null;

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getConnection()
   {
      return connection;
   }

   public void setConnection(String connection)
   {
      this.connection = connection;
   }

   public byte[] getByte()
   {
      return bin;
   }

   public void setByte(byte[] b)
   {
      bin = b;
   }

   public String toString()
   {
      return "name=" + getName() + ", type=" + getConnection() + " bytes= " +bin.toString();
   }
}
