/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class NodeAPITest {
    private Node<Object, Object> rootNode;
    private CacheSPI<Object, Object> cache;
    private TransactionManager tm;
    private static final Fqn<String> A = Fqn.fromString((String)"/a");
    private static final Fqn<String> B = Fqn.fromString((String)"/b");
    private static final Fqn<String> C = Fqn.fromString((String)"/c");
    private static final Fqn<String> D = Fqn.fromString((String)"/d");
    protected boolean optimistic = false;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache("META-INF/conf-test/local-tx-service.xml", false);
        this.cache.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.rootNode = this.cache.getRoot();
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            if (this.cache.getTransactionManager() != null) {
                try {
                    this.cache.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cache.stop();
        }
        if (this.rootNode != null) {
            this.rootNode = null;
        }
    }

    private void assertOptimistic() {
        assert (this.cache.getConfiguration().isNodeLockingOptimistic());
        boolean interceptorChainOK = false;
        for (CommandInterceptor i : this.cache.getInterceptorChain()) {
            if (i instanceof PessimisticLockInterceptor) assert (false) : "Not an optimistic locking chain!!";
            if (!(i instanceof OptimisticNodeInterceptor)) continue;
            interceptorChainOK = true;
        }
        assert (interceptorChainOK) : "Not an optimistic locking chain!!";
    }

    public void testAddingData() {
        if (this.optimistic) {
            this.assertOptimistic();
        }
        Node nodeA = this.rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
    }

    public void testAddingDataTx() throws Exception {
        this.tm.begin();
        Node nodeA = this.rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
        this.tm.commit();
    }

    public void testOverwritingDataTx() throws Exception {
        Node nodeA = this.rootNode.addChild(A);
        nodeA.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)nodeA.get((Object)"key"));
        this.tm.begin();
        this.rootNode.removeChild(A);
        this.cache.put(A, (Object)"k2", (Object)"v2");
        this.tm.commit();
        AssertJUnit.assertNull((Object)nodeA.get((Object)"key"));
        AssertJUnit.assertEquals((Object)"v2", (Object)nodeA.get((Object)"k2"));
    }

    public void testParentsAndChildren() {
        Node nodeA = this.rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = nodeA.addChild(C);
        Node nodeD = this.rootNode.addChild(D);
        AssertJUnit.assertEquals(this.rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        AssertJUnit.assertEquals(this.rootNode, (Object)nodeD.getParent());
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(A));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)this.rootNode.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(B));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertEquals((Object)nodeA, (Object)this.rootNode.getChild(A));
        AssertJUnit.assertEquals((Object)nodeD, (Object)this.rootNode.getChild(D));
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeA.getChild(B));
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeA.getChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().contains(nodeB));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().contains(nodeC));
        AssertJUnit.assertEquals((int)2, (int)nodeA.getChildren().size());
        AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(nodeD));
        AssertJUnit.assertEquals((int)2, (int)this.rootNode.getChildren().size());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.rootNode.removeChild(A));
        AssertJUnit.assertFalse((boolean)this.rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)this.rootNode.getChildren().contains(nodeD));
        AssertJUnit.assertEquals((int)1, (int)this.rootNode.getChildren().size());
        AssertJUnit.assertEquals((String)"double remove", (boolean)false, (boolean)this.rootNode.removeChild(A));
        AssertJUnit.assertEquals((String)"double remove", (boolean)false, (boolean)this.rootNode.removeChild(A.getLastElement()));
    }

    public void testLocking() throws Exception {
        this.tm.begin();
        Node nodeA = this.rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = nodeB.addChild(C);
        if (!this.optimistic) {
            AssertJUnit.assertEquals((int)3, (int)this.cache.getNumberOfNodes());
            AssertJUnit.assertEquals((int)4, (int)this.cache.getNumberOfLocksHeld());
        }
        this.tm.commit();
        this.tm.begin();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        nodeC.put((Object)"key", (Object)"value");
        if (!this.optimistic) {
            AssertJUnit.assertEquals((int)4, (int)this.cache.getNumberOfLocksHeld());
        }
        this.tm.commit();
    }

    public void testImmutabilityOfData() {
        this.rootNode.put((Object)"key", (Object)"value");
        Map m = this.rootNode.getData();
        try {
            m.put("x", "y");
            AssertJUnit.fail((String)"Map should be immutable!!");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.rootNode.getKeys().add(new Object());
            AssertJUnit.fail((String)"Key set should be immutable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefensiveCopyOfData() {
        this.rootNode.put((Object)"key", (Object)"value");
        Map data = this.rootNode.getData();
        Set keys = this.rootNode.getKeys();
        assert (keys.size() == 1);
        assert (keys.contains("key"));
        assert (data.size() == 1);
        assert (data.containsKey("key"));
        this.rootNode.put((Object)"key2", (Object)"value2");
        assert (keys.size() == 1);
        assert (keys.contains("key"));
        assert (data.size() == 1);
        assert (data.containsKey("key"));
    }

    public void testDefensiveCopyOfChildren() {
        Fqn childFqn = Fqn.fromString((String)"/child");
        this.rootNode.addChild(childFqn).put((Object)"k", (Object)"v");
        Set children = this.rootNode.getChildren();
        Set childrenNames = this.rootNode.getChildrenNames();
        assert (childrenNames.size() == 1);
        assert (childrenNames.contains(childFqn.getLastElement()));
        assert (children.size() == 1);
        assert (((Node)children.iterator().next()).getFqn().equals((Object)childFqn));
        this.rootNode.addChild(Fqn.fromString((String)"/child2"));
        assert (childrenNames.size() == 1);
        assert (childrenNames.contains(childFqn.getLastElement()));
        assert (children.size() == 1);
        assert (((Node)children.iterator().next()).getFqn().equals((Object)childFqn));
    }

    public void testImmutabilityOfChildren() {
        this.rootNode.addChild(A);
        try {
            this.rootNode.getChildren().clear();
            AssertJUnit.fail((String)"Collection of child nodes returned in getChildrenDirect() should be immutable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetChildrenUnderTx() throws Exception {
        Fqn A_B = Fqn.fromRelativeFqn(A, B);
        Fqn A_C = Fqn.fromRelativeFqn(A, C);
        this.tm.begin();
        this.cache.put(A_B, (Object)"1", (Object)"1");
        this.cache.put(A_C, (Object)"2", (Object)"2");
        if (!this.optimistic) {
            AssertJUnit.assertEquals((int)3, (int)this.cache.getNumberOfNodes());
            AssertJUnit.assertEquals((int)4, (int)this.cache.getNumberOfLocksHeld());
        } else {
            TransactionWorkspace<Object, Object> w = this.getTransactionWorkspace();
            assert (w.getNodes().size() == 4) : "Should be 4 nodes in the workspace, not " + w.getNodes().size();
            List deltas = ((WorkspaceNode)w.getNodes().get(Fqn.ROOT)).getMergedChildren();
            assert (((Set)deltas.get(0)).size() == 1) : "/ should have 1 child added";
            assert (((Set)deltas.get(1)).size() == 0) : "/ should have 0 children removed";
            deltas = ((WorkspaceNode)w.getNodes().get(A)).getMergedChildren();
            assert (((Set)deltas.get(0)).size() == 2) : "/ should have 2 children added";
            assert (((Set)deltas.get(1)).size() == 0) : "/ should have 0 children removed";
            deltas = ((WorkspaceNode)w.getNodes().get(A_B)).getMergedChildren();
            assert (((Set)deltas.get(0)).size() == 0) : "/a/b should have 0 children added";
            assert (((Set)deltas.get(1)).size() == 0) : "/a/b should have 0 children removed";
            deltas = ((WorkspaceNode)w.getNodes().get(A_C)).getMergedChildren();
            assert (((Set)deltas.get(0)).size() == 0) : "/a/c should have 0 children added";
            assert (((Set)deltas.get(1)).size() == 0) : "/a/c should have 0 children removed";
        }
        AssertJUnit.assertEquals((String)"Number of child", (int)2, (int)this.cache.getRoot().getChild(A).getChildren().size());
        this.tm.commit();
    }

    private TransactionWorkspace<Object, Object> getTransactionWorkspace() throws Exception {
        return ((OptimisticTransactionEntry)this.cache.getTransactionTable().get(this.cache.getTransactionTable().get(this.tm.getTransaction()))).getTransactionWorkSpace();
    }

    public void testGetChildAPI() {
        this.rootNode.addChild(A).addChild(B).addChild(C);
        this.rootNode.getChild(A).put((Object)"key", (Object)"value");
        this.rootNode.getChild(A).getChild(B).put((Object)"key", (Object)"value");
        this.rootNode.getChild(A).getChild(B).getChild(C).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.rootNode.getChild(A).get((Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.rootNode.getChild(A).getChild(B).get((Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.rootNode.getChild(A).getChild(B).getChild(C).get((Object)"key"));
        AssertJUnit.assertNull((Object)this.rootNode.getChild(Fqn.fromElements((Object[])new String[]{"nonexistent"})));
    }

    public void testClearingData() {
        this.rootNode.put((Object)"k", (Object)"v");
        this.rootNode.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)this.rootNode.getKeys().size());
        this.rootNode.clearData();
        AssertJUnit.assertEquals((int)0, (int)this.rootNode.getKeys().size());
        AssertJUnit.assertTrue((boolean)this.rootNode.getData().isEmpty());
    }

    public void testClearingDataTx() throws Exception {
        this.tm.begin();
        this.rootNode.put((Object)"k", (Object)"v");
        this.rootNode.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((int)2, (int)this.rootNode.getKeys().size());
        this.rootNode.clearData();
        AssertJUnit.assertEquals((int)0, (int)this.rootNode.getKeys().size());
        AssertJUnit.assertTrue((boolean)this.rootNode.getData().isEmpty());
        this.tm.commit();
        AssertJUnit.assertTrue((boolean)this.rootNode.getData().isEmpty());
    }

    public void testPutData() {
        AssertJUnit.assertTrue((boolean)this.rootNode.getData().isEmpty());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "v2");
        this.rootNode.putAll(map);
        AssertJUnit.assertEquals((int)2, (int)this.rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.rootNode.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.rootNode.get((Object)"k2"));
        map.clear();
        map.put("k3", "v3");
        this.rootNode.putAll(map);
        AssertJUnit.assertEquals((int)3, (int)this.rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.rootNode.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.rootNode.get((Object)"k2"));
        AssertJUnit.assertEquals((Object)"v3", (Object)this.rootNode.get((Object)"k3"));
        map.clear();
        map.put("k4", "v4");
        map.put("k5", "v5");
        this.rootNode.replaceAll(map);
        AssertJUnit.assertEquals((int)2, (int)this.rootNode.getData().size());
        AssertJUnit.assertEquals((Object)"v4", (Object)this.rootNode.get((Object)"k4"));
        AssertJUnit.assertEquals((Object)"v5", (Object)this.rootNode.get((Object)"k5"));
    }

    public void testGetChildrenNames() throws Exception {
        this.rootNode.addChild(A).put((Object)"k", (Object)"v");
        this.rootNode.addChild(B).put((Object)"k", (Object)"v");
        HashSet<Object> childrenNames = new HashSet<Object>();
        childrenNames.add(A.getLastElement());
        childrenNames.add(B.getLastElement());
        AssertJUnit.assertEquals(childrenNames, (Object)this.rootNode.getChildrenNames());
        this.tm.begin();
        this.rootNode.removeChild(B);
        AssertJUnit.assertFalse((boolean)this.rootNode.hasChild(B));
        childrenNames.remove(B.getLastElement());
        AssertJUnit.assertEquals(childrenNames, (Object)this.rootNode.getChildrenNames());
        this.tm.commit();
        AssertJUnit.assertEquals(childrenNames, (Object)this.rootNode.getChildrenNames());
    }

    public void testDoubleRemovalOfData() throws Exception {
        this.cache.put("/foo/1/2/3", (Object)"item", (Object)1);
        this.tm.begin();
        AssertJUnit.assertEquals((Object)this.cache.get("/foo/1/2/3", (Object)"item"), (Object)1);
        this.cache.removeNode("/foo/1");
        AssertJUnit.assertNull((Object)this.cache.getNode("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.cache.removeNode("/foo/1/2/3");
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2/3", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.exists("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2/3", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
    }

    public void testDoubleRemovalOfData2() throws Exception {
        this.cache.put("/foo/1/2", (Object)"item", (Object)1);
        this.tm.begin();
        AssertJUnit.assertEquals((Object)this.cache.get("/foo/1", (Object)"item"), null);
        this.cache.removeNode("/foo/1");
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.cache.removeNode("/foo/1/2");
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
        this.tm.commit();
        AssertJUnit.assertFalse((boolean)this.cache.exists("/foo/1"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1/2", (Object)"item"));
        AssertJUnit.assertNull((Object)this.cache.get("/foo/1", (Object)"item"));
    }
}

