/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.loader.TcpDelegatingCacheLoader;
import org.jboss.cache.loader.tcp.TcpCacheServer;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class TcpCacheLoaderTest
extends CacheLoaderTestsBase {
    protected static final int CACHE_SERVER_RESTART_DELAY_MS = 1000;
    protected static final int TCP_CACHE_LOADER_TIMEOUT_MS = 2000;
    protected static int START_COUNT = 0;
    static TcpCacheServer cacheServer = null;

    @BeforeClass
    public static void startCacheServer() {
        final CountDownLatch startedSignal = new CountDownLatch(1);
        Thread t = new Thread(){

            public void run() {
                try {
                    System.out.println("Starting TcpCacheServer");
                    cacheServer = new TcpCacheServer();
                    cacheServer.setBindAddress("127.0.0.1");
                    cacheServer.setPort(12121);
                    Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
                    CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(config);
                    cacheServer.setCache(cache);
                    cacheServer.create();
                    cacheServer.start();
                    ++START_COUNT;
                    startedSignal.countDown();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        boolean started = false;
        try {
            started = startedSignal.await(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!started) {
            throw new RuntimeException("Unable to start the TcpCacheServer after 120 seconds!!");
        }
    }

    @AfterClass
    public static void stopCacheServer() {
        if (cacheServer != null) {
            System.out.println("Stopping TcpCacheServer");
            cacheServer.stop();
        }
    }

    protected static void restartCacheServer() {
        TcpCacheLoaderTest.stopCacheServer();
        TcpCacheLoaderTest.startCacheServer();
    }

    public void testPartialLoadAndStore() {
    }

    public void testBuddyBackupStore() {
    }

    protected void configureCache() throws Exception {
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", TcpDelegatingCacheLoader.class.getName(), "host=127.0.0.1\nport=12121\ntimeout=2000", false, true, false));
    }

    public void testCacheServerRestartMidCall() throws Exception {
        CacheServerRestarter restarter = new CacheServerRestarter();
        restarter.restart = true;
        this.cache.addCacheListener((Object)restarter);
        int oldStartCount = START_COUNT;
        this.cache.put(FQN, (Object)"key", (Object)"value");
        assert (oldStartCount + 1 == START_COUNT) : "Cache server should have restarted!";
        assert (((Object)this.loader.get(FQN)).equals(Collections.singletonMap("key", "value")));
    }

    public void testCacheServerDelayedRestartMidCall() throws Exception {
        CacheServerRestarter restarter = new CacheServerRestarter();
        restarter.restart = false;
        restarter.delayedRestart = true;
        restarter.startAfter = 1000;
        this.cache.addCacheListener((Object)restarter);
        int oldStartCount = START_COUNT;
        this.cache.put(FQN, (Object)"key", (Object)"value");
        assert (oldStartCount + 1 == START_COUNT) : "Cache server should have restarted!";
        assert (((Object)this.loader.get(FQN)).equals(Collections.singletonMap("key", "value")));
    }

    public void testCacheServerTimeoutMidCall() throws Exception {
        CacheServerRestarter restarter = new CacheServerRestarter();
        restarter.restart = false;
        restarter.delayedRestart = true;
        restarter.startAfter = -1;
        this.cache.addCacheListener((Object)restarter);
        int oldStartCount = START_COUNT;
        try {
            this.cache.put(FQN, (Object)"key", (Object)"value");
            assert (false) : "Should have failed";
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        assert (oldStartCount == START_COUNT) : "Cache server should NOT have restarted!";
        TcpCacheLoaderTest.startCacheServer();
        assert (this.loader.get(FQN) == null);
    }

    public void testCacheServerRestartMidTransaction() throws Exception {
        int oldStartCount = START_COUNT;
        this.cache.getTransactionManager().begin();
        this.cache.put(FQN, (Object)"key", (Object)"value");
        TcpCacheLoaderTest.restartCacheServer();
        this.cache.put(FQN, (Object)"key2", (Object)"value2");
        this.cache.getTransactionManager().commit();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key", "value");
        m.put("key2", "value2");
        assert (oldStartCount + 1 == START_COUNT) : "Cache server should have restarted!";
        assert (((Object)this.loader.get(FQN)).equals(m));
    }

    public void testCacheServerRestartMidTransactionAfterPrepare() throws Exception {
        int oldStartCount = START_COUNT;
        this.cache.getTransactionManager().begin();
        this.cache.put(FQN, (Object)"key", (Object)"value");
        this.cache.put(FQN, (Object)"key2", (Object)"value2");
        GlobalTransaction gtx = this.cache.getTransactionTable().get(this.cache.getTransactionManager().getTransaction());
        OrderedSynchronizationHandler osh = this.cache.getTransactionTable().get(gtx).getOrderedSynchronizationHandler();
        osh.registerAtTail(new Synchronization(){

            public void beforeCompletion() {
                TcpCacheLoaderTest.restartCacheServer();
            }

            public void afterCompletion(int i) {
            }
        });
        this.cache.getTransactionManager().commit();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key", "value");
        m.put("key2", "value2");
        assert (oldStartCount + 1 == START_COUNT) : "Cache server should have restarted!";
        assert (((Object)this.loader.get(FQN)).equals(m));
    }

    @CacheListener
    public static class CacheServerRestarter {
        boolean restart;
        boolean delayedRestart;
        int startAfter;

        @NodeCreated
        public void restart(Event e) {
            if (e.isPre()) {
                if (this.restart) {
                    TcpCacheLoaderTest.restartCacheServer();
                } else if (this.delayedRestart) {
                    TcpCacheLoaderTest.stopCacheServer();
                    new Thread(){

                        public void run() {
                            if (CacheServerRestarter.this.startAfter > 0) {
                                TestingUtil.sleepThread(CacheServerRestarter.this.startAfter);
                                TcpCacheLoaderTest.startCacheServer();
                            }
                        }
                    }.start();
                }
            }
        }
    }
}

