/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshallerTestBase;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.marshall.RegionalizedReturnValue;
import org.jboss.cache.marshall.UnmarshalledReferences;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheMarshaller200Test
extends CacheMarshallerTestBase {
    public CacheMarshaller200Test() {
        this.currentVersion = "2.0.0.GA";
        this.currentVersionShort = 20;
        this.expectedMarshallerClass = CacheMarshaller200.class;
    }

    public void testRegionalisedStream() throws Exception {
        CacheMarshaller200 cm200 = new CacheMarshaller200();
        this.c.setUseRegionBasedMarshalling(true);
        cm200.injectDependencies(new RegionManager(), this.c, this.getClass().getClassLoader());
        cm200.init();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        cm200.objectToObjectStream((Object)"Hello World", oos, Fqn.fromString((String)"/hello"));
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        byte magic = ois.readByte();
        short ref = ois.readShort();
        System.out.println("Magic number is " + magic);
        assert (magic == 2);
        Fqn f = cm200.unmarshallFqn(ois, new UnmarshalledReferences());
        assert (f.equals((Object)Fqn.fromString((String)"/hello")));
    }

    public void testLeakageOfFqn() throws Throwable {
        ExecutorService e = Executors.newFixedThreadPool(1);
        final CopyOnWriteArrayList throwables = new CopyOnWriteArrayList();
        final CacheMarshaller200 cm200 = new CacheMarshaller200();
        this.c.setInactiveOnStartup(false);
        this.c.setUseRegionBasedMarshalling(true);
        this.c.setCacheMarshaller((Marshaller)cm200);
        this.cr.registerComponent((Object)cm200, CacheMarshaller200.class);
        this.cr.rewire();
        this.cr.start();
        RegionManager rm = (RegionManager)this.cr.getComponent(RegionManager.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        final Fqn region = Fqn.fromString((String)"/hello");
        Region r = rm.getRegion(region, true);
        r.registerContextClassLoader(this.getClass().getClassLoader());
        cm200.objectToObjectStream((Object)new ClusteredGetCommand(false, null), oos, region);
        oos.close();
        final byte[] stream = baos.toByteArray();
        for (int i = 0; i < 100; ++i) {
            if (i % 3 == 0) {
                e.execute(new Runnable(){

                    public void run() {
                        try {
                            RegionalizedMethodCall rmc = cm200.regionalizedMethodCallFromObjectStream(new ObjectInputStream(new ByteArrayInputStream(stream)));
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ObjectOutputStream outStream = new ObjectOutputStream(out);
                            RegionalizedReturnValue rrv = new RegionalizedReturnValue((Object)"A result", rmc);
                            cm200.objectToObjectStream((Object)rrv, outStream);
                            outStream.close();
                            out.close();
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
                            assert (in.readByte() == 2) : "The stream should start with an Fqn";
                            in.readShort();
                            Fqn f = cm200.unmarshallFqn(in, new UnmarshalledReferences());
                            assert (region.equals((Object)f)) : "Should use the same region for the response as was used for the request!";
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                    }
                });
                continue;
            }
            if (i % 3 == 1) {
                e.execute(new Runnable(){

                    public void run() {
                        try {
                            cm200.objectFromObjectStream(new ObjectInputStream(new ByteArrayInputStream(stream)));
                            cm200.objectToObjectStream(null, new ObjectOutputStream(new ByteArrayOutputStream()));
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                    }
                });
                continue;
            }
            if (i % 3 != 2) continue;
            e.execute(new Runnable(){

                public void run() {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream outStream = new ObjectOutputStream(out);
                        cm200.objectToObjectStream((Object)true, outStream);
                        outStream.close();
                        out.close();
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
                        byte magic = in.readByte();
                        assert (magic != 2) : "The stream should NOT start with an Fqn!";
                        assert (magic == 99) : "Should start with a NULL.  Instead, was " + magic;
                        assert (in.readByte() == 8) : "Should have a boolean magic number before the boolean value";
                        assert (in.readBoolean()) : "The boolean written to the stream should be true";
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                }
            });
        }
        e.shutdown();
        e.awaitTermination(60L, TimeUnit.SECONDS);
        for (Throwable t : throwables) {
            t.printStackTrace();
        }
        assert (throwables.size() == 0) : "Should not have caught any exceptions!";
    }
}

