/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.multiplexer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.cache.Cache;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MultiplexerTestHelper {
    public static final String MUX_STACK = "jbc-test";
    private final Set<JChannelFactory> factories = Collections.synchronizedSet(new HashSet());
    private final Set<Cache> caches = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureCacheForMux(Cache cache) throws Exception {
        Set<Cache> set = this.caches;
        synchronized (set) {
            ChannelFactory factory = this.createMuxChannelFactory(cache);
            cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory(factory);
            cache.getConfiguration().setMultiplexerStack(MUX_STACK);
        }
    }

    public ChannelFactory createMuxChannelFactory(Cache cache) throws Exception {
        return this.createMuxChannelFactory(this.getChannelProperties(cache));
    }

    private String getChannelProperties(Cache cache) {
        String props = cache.getConfiguration().getClusterConfig();
        return props == null ? "udp.xml" : props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFactory createMuxChannelFactory(String muxConfig) throws Exception {
        Set<JChannelFactory> set = this.factories;
        synchronized (set) {
            JChannelFactory factory = new JChannelFactory();
            factory.setDomain("jbc.mux.test");
            factory.setExposeChannels(false);
            factory.setMultiplexerConfig(MultiplexerTestHelper.getClusterConfigElement(muxConfig));
            this.factories.add(factory);
            return factory;
        }
    }

    public static Element getClusterConfigElement(String clusterConfig) throws Exception {
        clusterConfig = clusterConfig.trim();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.newDocument();
        Element top = doc.createElement("protocol_stacks");
        doc.appendChild(top);
        Element stack = doc.createElement("stack");
        stack.setAttribute("name", MUX_STACK);
        top.appendChild(stack);
        Element config = doc.createElement("config");
        StringTokenizer outer = new StringTokenizer(clusterConfig, ":");
        while (outer.hasMoreTokens()) {
            String protocol;
            String protName = protocol = outer.nextToken();
            String attribs = null;
            int nameEnd = protocol.indexOf(40);
            if (nameEnd > 0) {
                protName = protocol.substring(0, nameEnd);
                attribs = protocol.substring(nameEnd + 1, protocol.length() - 1);
            }
            Element element = doc.createElement(protName);
            if (attribs != null && attribs.length() > 0) {
                StringTokenizer inner = new StringTokenizer(attribs, ";");
                while (inner.hasMoreTokens()) {
                    String attrib = inner.nextToken();
                    int eq = attrib.indexOf(61);
                    String name = attrib.substring(0, eq);
                    String value = attrib.substring(eq + 1);
                    element.setAttribute(name, value);
                }
            }
            config.appendChild(element);
        }
        stack.appendChild(config);
        return top;
    }

    public void tearDown() {
        this.factories.clear();
        this.caches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        MultiplexerTestHelper helper = new MultiplexerTestHelper();
        try {
            helper.createMuxChannelFactory("udp.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            helper.tearDown();
        }
    }
}

