/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.profiling.AbstractProfileTest;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"profiling"})
public class ProfileTest
extends AbstractProfileTest {
    protected static final long DURATION = 300000L;
    protected static final int NUM_THREADS = 15;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 25;
    protected static final int MAX_DEPTH = 3;
    protected static final int MAX_OVERALL_NODES = 200;
    protected static final int WARMUP_LOOPS = 20000;
    private List<Fqn> fqns = new ArrayList<Fqn>(200);
    private Random r = new Random();
    private Log log = LogFactory.getLog(ProfileTest.class);

    public void testLocalModePess() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.runCompleteTest();
    }

    public void testLocalModeOpt() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.runCompleteTest();
    }

    public void testReplSync() throws Exception {
        this.runCompleteTest();
    }

    public void testReplAsync() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.runCompleteTest();
    }

    public void testReplSyncOptimistic() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    public void testReplAsyncOptimistic() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    public void testReplSyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSync();
    }

    public void testReplAsyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsync();
    }

    public void testReplSyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSyncOptimistic();
    }

    public void testReplAsyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsyncOptimistic();
    }

    private void runCompleteTest() throws Exception {
        this.init();
        this.startup();
        this.warmup();
        this.doTest();
        System.in.read();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting init() phase");
        this.fqns.clear();
        for (int i = 0; i < 200; ++i) {
            Fqn fqn = this.createRandomFqn(this.r);
            while (this.fqns.contains(fqn)) {
                fqn = this.createRandomFqn(this.r);
            }
            if (i % 10 == 0) {
                this.log.warn((Object)("Generated " + i + " fqns"));
            }
            this.fqns.add(fqn);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    private Fqn createRandomFqn(Random r) {
        String s = "/";
        int depth = r.nextInt(3);
        for (int i = 0; i < depth; ++i) {
            s = s + r.nextInt(Integer.MAX_VALUE) + "/";
        }
        return Fqn.fromString((String)s);
    }

    private void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ExecutorService exec = Executors.newFixedThreadPool(15);
        this.log.warn((Object)"Starting warmup");
        for (final Fqn f : this.fqns) {
            exec.execute(new Runnable(){

                public void run() {
                    ProfileTest.this.cache.put(f, Collections.emptyMap());
                }
            });
        }
        for (int i = 0; i < 20000; ++i) {
            exec.execute(new Runnable(){

                public void run() {
                    Fqn f = (Fqn)ProfileTest.this.fqns.get(ProfileTest.this.r.nextInt(200));
                    ProfileTest.this.cache.get(f, (Object)"");
                    ProfileTest.this.cache.put(f, (Object)"k", (Object)"v");
                    ProfileTest.this.cache.remove(f, (Object)"k");
                }
            });
        }
        exec.shutdown();
        exec.awaitTermination(360L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished warmup.  " + this.printDuration(duration)));
        this.cache.removeNode(Fqn.ROOT);
    }

    private void doTest() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(15);
        long end = System.currentTimeMillis() + 300000L;
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting test");
        int i = 0;
        while (System.currentTimeMillis() < end) {
            MyRunnable r = null;
            switch (i % 3) {
                case 0: {
                    r = new Putter(i++);
                    break;
                }
                case 1: {
                    r = new Getter(i++);
                    break;
                }
                case 2: {
                    r = new Remover(i++);
                }
            }
            exec.execute(r);
            TestingUtil.sleepRandom(25);
        }
        this.log.warn((Object)"Finished generating runnables; awaiting executor completion");
        exec.shutdown();
        exec.awaitTermination((long)i * 250L, TimeUnit.MILLISECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished test.  " + this.printDuration(duration)));
    }

    private String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int len = this.r.nextInt(10);
        for (int i = 0; i < len; ++i) {
            sb.append((char)(63 + this.r.nextInt(26)));
        }
        return sb.toString();
    }

    private String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    public void testStateTransfer() throws Exception {
        throw new Exception("Implement me");
    }

    public void testStartup() throws Exception {
        throw new Exception("Implement me");
    }

    public void testCacheLoading() throws Exception {
        throw new Exception("Implement me");
    }

    public void testPassivation() throws Exception {
        throw new Exception("Implement me");
    }

    private class Remover
    extends MyRunnable {
        private Remover(int id) {
            this.id = id;
            this.mode = Mode.REMOVE;
        }
    }

    private class Getter
    extends MyRunnable {
        private Getter(int id) {
            this.id = id;
            this.mode = Mode.GET;
        }
    }

    private class Putter
    extends MyRunnable {
        private Putter(int id) {
            this.id = id;
            this.mode = Mode.PUT;
        }
    }

    private abstract class MyRunnable
    implements Runnable {
        int id;
        Mode mode;

        private MyRunnable() {
        }

        public void run() {
            if (this.id % 100 == 0) {
                ProfileTest.this.log.warn((Object)("Processing iteration " + this.id));
            }
            String k = ProfileTest.this.getRandomString();
            Fqn f = (Fqn)ProfileTest.this.fqns.get(ProfileTest.this.r.nextInt(200));
            switch (this.mode) {
                case PUT: {
                    ProfileTest.this.cache.put(f, (Object)k, (Object)ProfileTest.this.getRandomString());
                    break;
                }
                case GET: {
                    ProfileTest.this.cache.get(f, (Object)k);
                    break;
                }
                case REMOVE: {
                    ProfileTest.this.cache.remove(f, (Object)k);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        PUT,
        GET,
        REMOVE;

    }
}

