/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import net.jcip.annotations.Immutable;

@Immutable
public class Version {
    public static final String version = "2.2.0.CR7";
    public static final String codename = "Poblano";
    static final byte[] version_id = new byte[]{48, 50, 50, 48, 67, 55};
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;
    private static final short SHORT_1_2_3 = Version.encodeVersion(1, 2, 3);
    private static final short SHORT_1_2_4_SP2 = Version.encodeVersion(1, 2, 4);

    public static void main(String[] args) {
        System.out.println("\nVersion: \t2.2.0.CR7");
        System.out.println("Codename: \tPoblano");
        System.out.println("History:  \t(see http://jira.jboss.com/jira/browse/JBCACHE for details)\n");
    }

    public static String printVersion() {
        return "JBossCache 'Poblano' 2.2.0.CR7";
    }

    public static String printVersionId(byte[] v, int len) {
        StringBuilder sb = new StringBuilder();
        if (v != null) {
            if (len <= 0) {
                len = v.length;
            }
            for (int i = 0; i < len; ++i) {
                sb.append((char)v[i]);
            }
        }
        return sb.toString();
    }

    public static String printVersionId(byte[] v) {
        StringBuilder sb = new StringBuilder();
        if (v != null) {
            for (byte aV : v) {
                sb.append((char)aV);
            }
        }
        return sb.toString();
    }

    public static boolean compareTo(byte[] v) {
        if (v == null) {
            return false;
        }
        if (v.length < version_id.length) {
            return false;
        }
        for (int i = 0; i < version_id.length; ++i) {
            if (version_id[i] == v[i]) continue;
            return false;
        }
        return true;
    }

    public static int getLength() {
        return version_id.length;
    }

    public static short getVersionShort() {
        return Version.getVersionShort(version);
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        if ("1.2.4".equals(versionString)) {
            return 124;
        }
        if ("1.2.4.SP1".equals(versionString)) {
            return 1241;
        }
        String[] parts = versionString.split("[\\.\\-]");
        int a = 0;
        int b = 0;
        int c = 0;
        if (parts.length > 0) {
            a = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            b = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            c = Integer.parseInt(parts[2]);
        }
        return Version.encodeVersion(a, b, c);
    }

    public static String getVersionString(short versionShort) {
        if (versionShort == SHORT_1_2_4_SP2) {
            return "1.2.4.SP2";
        }
        switch (versionShort) {
            case 124: {
                return "1.2.4";
            }
            case 1241: {
                return "1.2.4.SP1";
            }
        }
        return Version.decodeVersion(versionShort);
    }

    public static short encodeVersion(int major, int minor, int patch) {
        return (short)((major << 11) + (minor << 6) + patch);
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        return major + "." + minor + "." + patch;
    }

    public static boolean isBefore124(short version) {
        return version > 1241 && version <= SHORT_1_2_3;
    }

    public static class Retro {
        public static void main(String[] args) {
            System.out.println("\nVersion: \t2.2.0.CR7 (Retroweaved for JDK 1.4.x compatibility)");
            System.out.println("Codename: \tPoblano");
            System.out.println("History:  \t(see http://jira.jboss.com/jira/browse/JBCACHE for details)\n");
        }
    }
}

