/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.LinkedList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNodeCommand
extends AbstractDataCommand
implements ReversibleCommand {
    public static final int METHOD_ID = 48;
    private final List<Fqn> newlyCreated = new LinkedList<Fqn>();

    public CreateNodeCommand(Fqn fqn) {
        this.fqn = fqn;
        this.newlyCreated.add(fqn);
    }

    public CreateNodeCommand() {
    }

    @Override
    public int getCommandId() {
        return 48;
    }

    @Override
    public void setGlobalTransaction(GlobalTransaction gtx) {
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return null;
    }

    @Override
    public Object perform(InvocationContext ctx) {
        Object[] results = this.dataContainer.createNodes(this.fqn);
        List created = (List)results[0];
        boolean foundFqn = false;
        if (!created.isEmpty()) {
            for (NodeSPI n : created) {
                if (this.fqn.equals(n.getFqn())) {
                    foundFqn = true;
                }
                this.newlyCreated.add(n.getFqn());
            }
        }
        if (this.newlyCreated != null && !foundFqn) {
            this.newlyCreated.remove(this.fqn);
        }
        return results[1];
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitCreateNodeCommand(ctx, this);
    }

    @Override
    public void rollback() {
        if (this.newlyCreated != null) {
            for (Fqn f : this.newlyCreated) {
                this.dataContainer.removeFromDataStructure(f, true);
            }
        }
    }

    @Override
    public String toString() {
        return "CreateNodeCommand{fqn=" + this.fqn + ", newlyCreated=" + this.newlyCreated + '}';
    }

    List<Fqn> getNewlyCreated() {
        return this.newlyCreated;
    }
}

