/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;

public class ThreadNamingPattern {
    private final boolean includeClusterName;
    private final boolean includeLocalAddress;
    private String clusterName;
    private Address address;

    public ThreadNamingPattern(String pattern) {
        this.includeClusterName = pattern.contains("c");
        this.includeLocalAddress = pattern.contains("l");
    }

    public void setClusterName(String channelName) {
        this.clusterName = channelName;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public boolean isIncludeLocalAddress() {
        return this.includeLocalAddress;
    }

    public boolean isIncludeClusterName() {
        return this.includeClusterName;
    }

    public String renameThread(Thread runner) {
        String oldName = null;
        if (runner != null) {
            oldName = runner.getName();
            this.renameThread(oldName, runner);
        }
        return oldName;
    }

    public String renameThread(String base_name, Thread runner) {
        String oldName = null;
        if (runner != null) {
            oldName = runner.getName();
            StringBuilder threadName = new StringBuilder();
            threadName.append(base_name);
            if (this.isIncludeClusterName()) {
                if (threadName.length() > 0) {
                    threadName.append(',');
                }
                threadName.append(this.clusterName);
            }
            if (this.isIncludeLocalAddress()) {
                if (threadName.length() > 0) {
                    threadName.append(',');
                }
                threadName.append(this.address);
            }
            runner.setName(threadName.toString());
        }
        return oldName;
    }
}

