/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class NodeReplicatedMoveTest {
    protected Node<Object, Object> rootNode;
    protected Node<Object, Object> nodeA;
    protected Node<Object, Object> nodeB;
    protected Node<Object, Object> nodeC;
    protected Node<Object, Object> nodeD;
    protected Node<Object, Object> nodeE;
    protected CacheSPI<Object, Object> cache1;
    protected CacheSPI<Object, Object> cache2;
    protected TransactionManager tm;
    protected static final Fqn<String> A = Fqn.fromString((String)"/a");
    protected static final Fqn<String> B = Fqn.fromString((String)"/b");
    protected static final Fqn<String> C = Fqn.fromString((String)"/c");
    protected static final Fqn<String> D = Fqn.fromString((String)"/d");
    protected static final Fqn<String> E = Fqn.fromString((String)"/e");
    protected Object k = "key";
    protected Object vA = "valueA";
    protected Object vB = "valueB";
    protected Object vC = "valueC";
    protected Object vD = "valueD";
    protected Object vE = "valueE";
    protected boolean optimistic = false;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        this.cache1.getConfiguration().setSyncRollbackPhase(true);
        this.cache1.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache1.start();
        this.rootNode = this.cache1.getRoot();
        this.tm = this.cache1.getTransactionManager();
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache2.getConfiguration().setSyncCommitPhase(true);
        this.cache2.getConfiguration().setSyncRollbackPhase(true);
        this.cache2.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache2.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        if (this.rootNode != null) {
            this.rootNode = null;
        }
    }

    public void testReplicatability() {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        this.nodeA.put(this.k, this.vA);
        this.nodeB.put(this.k, this.vB);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(this.k));
        this.cache1.move(this.nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(B).get(this.k));
    }

    public void testInvalidations() throws Exception {
        block4: {
            this.cache1.stop();
            this.cache2.stop();
            this.cache1.destroy();
            this.cache2.destroy();
            if (this.optimistic) {
                this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
                this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            }
            this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            this.cache1.start();
            this.cache2.start();
            this.nodeA = this.rootNode.addChild(A);
            this.nodeB = this.nodeA.addChild(B);
            this.nodeA.put(this.k, this.vA);
            this.nodeB.put(this.k, this.vB);
            AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
            AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(this.k));
            this.assertInvalidated((Cache)this.cache2, (Fqn)A, "Should be invalidated", this.optimistic);
            this.assertInvalidated((Cache)this.cache2, Fqn.fromRelativeElements(A, (Object[])new Object[]{B.getLastElement()}), "Should be invalidated", this.optimistic);
            this.cache1.move(this.nodeB.getFqn(), Fqn.ROOT);
            AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
            AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(B).get(this.k));
            this.assertInvalidated((Cache)this.cache2, (Fqn)A, "Should be invalidated", this.optimistic);
            this.assertInvalidated((Cache)this.cache2, (Fqn)B, "Should be invalidated", this.optimistic);
            this.cache2.getRoot().addChild(A).put((Object)"k2", (Object)"v2");
            try {
                this.cache1.move(B, A);
                if (!this.optimistic) assert (false) : "Should throw an exception!";
            }
            catch (NodeNotExistsException expected) {
                if (!this.optimistic || $assertionsDisabled) break block4;
                throw new AssertionError((Object)"Should not have thrown an exception!");
            }
        }
    }

    private void assertInvalidated(Cache cache, Fqn fqn, String msg, boolean optimistic) {
        assert (cache.getRoot().getChild(fqn) == null) : msg;
        NodeSPI n = ((CacheSPI)cache).peek(fqn, true, true);
        assert (n == null || optimistic) : msg;
        assert (!optimistic || !n.isValid()) : msg;
    }

    public void testReplTxCommit() throws Exception {
        Fqn A_B = Fqn.fromRelativeFqn(A, B);
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        this.nodeA.put(this.k, this.vA);
        this.nodeB.put(this.k, this.vB);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(this.k));
        this.tm.begin();
        this.cache1.move(this.nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.get(A, this.k));
        AssertJUnit.assertNull((Object)this.cache1.get(A_B, this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.get(B, this.k));
        this.tm.commit();
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(B).get(this.k));
    }

    public void testReplTxRollback() throws Exception {
        this.nodeA = this.rootNode.addChild(A);
        this.nodeB = this.nodeA.addChild(B);
        this.nodeA.put(this.k, this.vA);
        this.nodeB.put(this.k, this.vB);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(this.k));
        this.tm.begin();
        this.cache1.move(this.nodeB.getFqn(), Fqn.ROOT);
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.get(A, this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.get(B, this.k));
        this.tm.rollback();
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache1.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache1.getRoot().getChild(A).getChild(B).get(this.k));
        AssertJUnit.assertEquals((Object)this.vA, (Object)this.cache2.getRoot().getChild(A).get(this.k));
        AssertJUnit.assertEquals((Object)this.vB, (Object)this.cache2.getRoot().getChild(A).getChild(B).get(this.k));
    }
}

