/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.pfer;

import java.util.List;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups", "transaction"})
public abstract class PutForExternalReadTestBase {
    protected CacheSPI<String, String> cache1;
    protected CacheSPI<String, String> cache2;
    ReplicationListener replListener1;
    ReplicationListener replListener2;
    protected TransactionManager tm1;
    protected TransactionManager tm2;
    protected Fqn<String> fqn = Fqn.fromString((String)"/one/two");
    protected Fqn<String> parentFqn = this.fqn.getParent();
    protected String key = "k";
    protected String value = "v";
    protected String value2 = "v2";
    protected boolean useTx;
    protected boolean optimistic;
    protected Configuration.CacheMode cacheMode;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        DefaultCacheFactory cf = new DefaultCacheFactory();
        this.cache1 = (CacheSPI)cf.createCache(UnitTestCacheConfigurationFactory.createConfiguration(this.cacheMode), false);
        this.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache1.start();
        this.tm1 = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.cache2 = (CacheSPI)cf.createCache(UnitTestCacheConfigurationFactory.createConfiguration(this.cacheMode), false);
        this.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2.getConfiguration().setNodeLockingScheme(this.optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache2.start();
        this.tm2 = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{this.cache1, this.cache2});
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
    }

    public void testNoOpWhenLockedAnd0msTimeout() throws Exception {
        this.cache1.put(this.parentFqn, (Object)this.key, (Object)this.value);
        this.tm1.begin();
        this.cache1.put(this.parentFqn, (Object)this.key, (Object)this.value2);
        NodeSPI parentNode = null;
        TransactionWorkspace workspace = null;
        if (this.optimistic) {
            workspace = this.extractTransactionWorkspace((Cache)this.cache1);
        } else {
            parentNode = (NodeSPI)this.cache1.getRoot().getChild(this.parentFqn);
        }
        Transaction t = this.tm1.suspend();
        this.assertLocked(this.parentFqn, parentNode, workspace, true);
        long startTime = System.currentTimeMillis();
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        long waited = System.currentTimeMillis() - startTime;
        AssertJUnit.assertTrue((String)("Should not wait " + waited + " millis for lock timeout, should attempt to acquite lock with 0ms!"), (waited < this.cache1.getConfiguration().getLockAcquisitionTimeout() ? 1 : 0) != 0);
        this.tm1.resume(t);
        this.tm1.commit();
        this.asyncWait();
        AssertJUnit.assertEquals((String)"Parent node write should have succeeded", (String)this.value2, (String)((String)this.cache1.get(this.parentFqn, (Object)this.key)));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"Parent node write should have invalidated", (Object)this.cache2.get(this.parentFqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"Parent node write should have replicated", (String)this.value2, (String)((String)this.cache2.get(this.parentFqn, (Object)this.key)));
        }
        if (!this.optimistic) {
            AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)this.cache1.get(this.fqn, (Object)this.key));
            AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)this.cache2.get(this.fqn, (Object)this.key));
        }
    }

    public void testNoOpWhenNodePresent() {
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.asyncWait();
        AssertJUnit.assertEquals((String)"PFER should have succeeded", (String)this.value, (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should not have effected cache2", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have replicated", (String)this.value, (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.cache1.removeNode(this.fqn);
        this.asyncWait();
        AssertJUnit.assertFalse((String)"Should have reset", (boolean)this.cache1.getRoot().hasChild(this.fqn));
        AssertJUnit.assertFalse((String)"Should have reset", (boolean)this.cache2.getRoot().hasChild(this.fqn));
        this.cache1.put(this.fqn, (Object)this.key, (Object)this.value);
        this.asyncWait();
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value2);
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)this.value, (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)this.value, (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
    }

    private Vector<Address> anyAddresses() {
        EasyMock.anyObject();
        return null;
    }

    public void testAsyncForce() throws Exception {
        RPCManager rpcManager = (RPCManager)EasyMock.createNiceMock(RPCManager.class);
        RPCManager originalRpcManager = this.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        List memberList = originalRpcManager.getMembers();
        EasyMock.expect((Object)rpcManager.getMembers()).andReturn((Object)memberList).anyTimes();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(this.cache1);
        cr.registerComponent((Object)rpcManager, RPCManager.class);
        cr.rewire();
        if (!this.isUsingInvalidation()) {
            EasyMock.expect((Object)rpcManager.callRemoteMethods(this.anyAddresses(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.eq((boolean)false), EasyMock.anyLong(), EasyMock.anyBoolean())).andReturn(null);
        }
        EasyMock.replay((Object[])new Object[]{rpcManager});
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        EasyMock.verify((Object[])new Object[]{rpcManager});
        TestingUtil.extractComponentRegistry(this.cache1).registerComponent((Object)originalRpcManager, RPCManager.class);
        this.cache1.removeNode(this.fqn);
    }

    public void testTxSuspension() throws Exception {
        this.cache1.put(this.parentFqn, (Object)this.key, (Object)this.value);
        this.tm1.begin();
        this.cache1.get(this.parentFqn, (Object)this.key);
        NodeSPI parentNode = null;
        TransactionWorkspace workspace = null;
        if (this.optimistic) {
            workspace = this.extractTransactionWorkspace((Cache)this.cache1);
        } else {
            parentNode = (NodeSPI)this.cache1.getRoot().getChild(this.parentFqn);
        }
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        Transaction t = this.tm1.suspend();
        this.asyncWait();
        this.assertLocked(this.parentFqn, parentNode, workspace, false);
        AssertJUnit.assertEquals((String)"PFER should have completed", (String)this.value, (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should not have effected cache2", (Object)this.cache2.get(this.fqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have completed", (String)this.value, (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        }
        this.tm1.resume(t);
        this.tm1.commit();
        this.asyncWait();
        AssertJUnit.assertEquals((String)"parent fqn tx should have completed", (String)this.value, (String)((String)this.cache1.get(this.parentFqn, (Object)this.key)));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"parent fqn tx should have invalidated cache2", (Object)this.cache2.get(this.parentFqn, (Object)this.key));
        } else {
            AssertJUnit.assertEquals((String)"parent fqn tx should have completed", (String)this.value, (String)((String)this.cache2.get(this.parentFqn, (Object)this.key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionSuppression() throws Exception {
        RPCManager barfingRpcManager = (RPCManager)EasyMock.createNiceMock(RPCManager.class);
        RPCManager originalRpcManager = this.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        try {
            List memberList = originalRpcManager.getMembers();
            EasyMock.expect((Object)barfingRpcManager.getMembers()).andReturn((Object)memberList).anyTimes();
            EasyMock.expect((Object)barfingRpcManager.getLocalAddress()).andReturn((Object)originalRpcManager.getLocalAddress()).anyTimes();
            EasyMock.expect((Object)barfingRpcManager.callRemoteMethods(this.anyAddresses(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyLong(), EasyMock.anyBoolean())).andThrow((Throwable)new RuntimeException("Barf!")).anyTimes();
            EasyMock.replay((Object[])new Object[]{barfingRpcManager});
            TestingUtil.extractComponentRegistry(this.cache1).registerComponent((Object)barfingRpcManager, RPCManager.class);
            this.cache1.getConfiguration().getRuntimeConfig().setRPCManager(barfingRpcManager);
            TestingUtil.extractComponentRegistry(this.cache1).rewire();
            try {
                this.cache1.put(this.fqn, (Object)this.key, (Object)this.value);
                if (!this.optimistic) {
                    AssertJUnit.fail((String)"Should have barfed");
                }
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            if (this.optimistic && !this.isUsingInvalidation()) {
                AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)this.key));
            } else {
                try {
                    this.cache1.removeNode(this.fqn);
                    if (!this.isUsingInvalidation()) {
                        AssertJUnit.fail((String)"Should have barfed");
                    }
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            AssertJUnit.assertNull((String)"Should have cleaned up", (Object)this.cache1.get(this.fqn, (Object)this.key));
            this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        }
        finally {
            TestingUtil.extractComponentRegistry(this.cache1).registerComponent((Object)originalRpcManager, RPCManager.class);
        }
    }

    public void testBasicPropagation() throws Exception {
        assert (!this.cache1.exists(this.fqn));
        assert (!this.cache2.exists(this.fqn));
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.asyncWait();
        AssertJUnit.assertEquals((String)"PFER updated cache1", (String)this.value, (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
        String expected = this.isUsingInvalidation() ? null : this.value;
        AssertJUnit.assertEquals((String)"PFER propagated to cache2 as expected", (Object)expected, (Object)this.cache2.get(this.fqn, (Object)this.key));
        this.cache2.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.asyncWait();
        AssertJUnit.assertEquals((String)"PFER updated cache2", (String)this.value, (String)((String)this.cache2.get(this.fqn, (Object)this.key)));
        AssertJUnit.assertEquals((String)"Cache1 should be unaffected", (String)this.value, (String)((String)this.cache1.get(this.fqn, (Object)this.key)));
    }

    public void testSimpleCacheModeLocal() throws Exception {
        this.cacheModeLocalTest(false);
    }

    public void testCacheModeLocalInTx() throws Exception {
        this.cacheModeLocalTest(true);
    }

    public void testMemLeakOnSuspendedTransactions() throws Exception {
        Fqn fqn2 = Fqn.fromString((String)"/fqn/two");
        this.tm1.begin();
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.tm1.commit();
        this.asyncWait();
        assert (this.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (this.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (this.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (this.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        this.tm1.begin();
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.cache1.put(fqn2, (Object)this.key, (Object)this.value);
        this.tm1.commit();
        this.asyncWait();
        assert (this.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (this.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (this.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (this.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        this.tm1.begin();
        this.cache1.put(fqn2, (Object)this.key, (Object)this.value);
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.tm1.commit();
        this.asyncWait();
        assert (this.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (this.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (this.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (this.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        this.tm1.begin();
        this.cache1.put(fqn2, (Object)this.key, (Object)this.value);
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        this.cache1.put(fqn2, (Object)this.key, (Object)this.value);
        this.tm1.commit();
        this.asyncWait();
        assert (this.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (this.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (this.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (this.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
    }

    private void cacheModeLocalTest(boolean transactional) throws Exception {
        RPCManager rpcManager = (RPCManager)EasyMock.createMock(RPCManager.class);
        RPCManager originalRpcManager = this.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        this.cache1.getConfiguration().getRuntimeConfig().setRPCManager(rpcManager);
        EasyMock.replay((Object[])new Object[]{rpcManager});
        if (transactional) {
            this.tm1.begin();
        }
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.putForExternalRead(this.fqn, (Object)this.key, (Object)this.value);
        if (transactional) {
            this.tm1.commit();
        }
        EasyMock.verify((Object[])new Object[]{rpcManager});
        this.cache1.getConfiguration().getRuntimeConfig().setRPCManager(originalRpcManager);
        this.cache1.removeNode(this.fqn);
    }

    protected void assertLocked(Fqn fqn, NodeSPI n, TransactionWorkspace workspace, boolean write_locked) throws Exception {
        if (workspace != null) {
            AssertJUnit.assertNotNull((String)("node " + fqn + " should be in transaction workspace"), (Object)workspace.getNode(fqn));
        } else {
            NodeLock lock = n.getLock();
            AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lock.isLocked());
            if (write_locked) {
                AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked" + (lock.isReadLocked() ? " but is read-locked instead!" : "!")), (boolean)lock.isWriteLocked());
            } else {
                AssertJUnit.assertTrue((String)("node " + fqn + " is not read-locked" + (lock.isWriteLocked() ? " but is write-locked instead!" : "!")), (boolean)lock.isReadLocked());
            }
        }
    }

    protected TransactionWorkspace extractTransactionWorkspace(Cache c) {
        CacheSPI cs = (CacheSPI)c;
        try {
            GlobalTransaction gtx = cs.getTransactionTable().get(cs.getTransactionManager().getTransaction());
            OptimisticTransactionEntry entry = (OptimisticTransactionEntry)cs.getTransactionTable().get(gtx);
            return entry.getTransactionWorkSpace();
        }
        catch (SystemException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)"Unable to extract transaction workspace from cache");
            return null;
        }
    }

    protected void asyncWait() {
        TestingUtil.sleepThread(500L);
    }

    protected boolean isUsingInvalidation() {
        return this.cacheMode == Configuration.CacheMode.INVALIDATION_ASYNC || this.cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }
}

