/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BuddyFqnTransformerTest {
    private BuddyFqnTransformer buddyFqnTransformer = new BuddyFqnTransformer();

    public void testActualFqn() {
        Fqn backupFqn = Fqn.fromString((String)"/_BUDDY_BACKUP_/1.2.3.4_5678/a/b/c/d");
        assert (this.buddyFqnTransformer.getActualFqn(backupFqn).equals((Object)Fqn.fromString((String)"/a/b/c/d")));
        backupFqn = Fqn.fromString((String)"/_BUDDY_BACKUP_/1.2.3.4_5678");
        Fqn actual = this.buddyFqnTransformer.getActualFqn(backupFqn);
        assert (actual.equals((Object)Fqn.ROOT));
    }

    public void testBackupRootFqn() {
        Fqn backupFqn = Fqn.fromString((String)"/_BUDDY_BACKUP_/1.2.3.4_5678/a/b/c/d");
        assert (this.buddyFqnTransformer.getBackupRootFromFqn(backupFqn).equals((Object)Fqn.fromString((String)"/_BUDDY_BACKUP_/1.2.3.4_5678"))) : "Got " + this.buddyFqnTransformer.getBackupRootFromFqn(backupFqn);
    }

    public void testGetActualFqnOnBuddyBackupRoot() {
        assert (Fqn.ROOT == this.buddyFqnTransformer.getActualFqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN));
    }

    public void testBackupRootFromFqnOnBuddyBackupRoot() {
        assert (Fqn.ROOT == this.buddyFqnTransformer.getBackupRootFromFqn(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN));
    }
}

