/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class BuddyManagerTest {
    private static final String DUMMY_LOCAL_ADDRESS = "myLocalAddress:12345";
    private BuddyFqnTransformer fqnTransformer;

    public void testConstruction1() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n          <buddyLocatorProperties>numBuddies = 3</buddyLocatorProperties>\n          <buddyPoolName>groupOne</buddyPoolName></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertEquals((String)"groupOne", (String)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)3, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    public void testConstruction2() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled>\n          <buddyLocatorClass>org.i.dont.exist.PhantomBuddyLocator</buddyLocatorClass>\n          <buddyLocatorProperties>numBuddies = 3</buddyLocatorProperties>\n          <buddyPoolName>groupOne</buddyPoolName></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertEquals((String)"groupOne", (String)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    public void testConstruction3() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>false</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((!mgr.isEnabled() ? 1 : 0) != 0);
    }

    public void testConstruction4() throws Exception {
        String xmlConfig = "<config><buddyReplicationEnabled>true</buddyReplicationEnabled></config>";
        Element element = XmlHelper.stringToElement((String)xmlConfig);
        BuddyReplicationConfig config = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
        BuddyManager mgr = new BuddyManager(config);
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertNull((Object)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    private BuddyManager createBasicBuddyManager() {
        BuddyManager bm = null;
        try {
            Element element = XmlHelper.stringToElement((String)"<config><buddyReplicationEnabled>true</buddyReplicationEnabled></config>");
            BuddyReplicationConfig cfg = XmlConfigurationParser.parseBuddyReplicationConfig((Element)element);
            bm = new BuddyManager(cfg);
            bm.injectDependencies(null, null, null, null, null, null, null, null, new BuddyFqnTransformer());
            CommandsFactory commandsFactory = new CommandsFactory();
            commandsFactory.initialize(null, null, null, null, null, null, null, new Configuration(), null, new BuddyFqnTransformer());
            bm.initFqnTransformer(DUMMY_LOCAL_ADDRESS, commandsFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bm;
    }

    public void testFqnManipulation() {
        Fqn fqn1 = Fqn.fromString((String)"/hello/world");
        PutKeyValueCommand call1 = new PutKeyValueCommand(null, fqn1, (Object)"key", (Object)"value");
        ReplicateCommand call2 = new ReplicateCommand((ReplicableCommand)call1);
        BuddyManager bm = this.createBasicBuddyManager();
        ReplicateCommand newReplicatedCall = bm.transformReplicateCommand(call2);
        PutKeyValueCommand newPutCall = (PutKeyValueCommand)newReplicatedCall.getSingleModification();
        Fqn expected = Fqn.fromString((String)"/_BUDDY_BACKUP_/myLocalAddress:12345/hello/world");
        AssertJUnit.assertEquals((Object)expected, (Object)newPutCall.getFqn());
    }

    public void testRootFqnManipulation() {
        Fqn fqn1 = Fqn.ROOT;
        PutKeyValueCommand call1 = new PutKeyValueCommand(null, fqn1, (Object)"key", (Object)"value");
        ReplicateCommand call2 = new ReplicateCommand((ReplicableCommand)call1);
        BuddyManager bm = this.createBasicBuddyManager();
        ReplicateCommand newReplicatedCall = bm.transformReplicateCommand(call2);
        PutKeyValueCommand newPutCall = (PutKeyValueCommand)newReplicatedCall.getSingleModification();
        Fqn expected = Fqn.fromString((String)"/_BUDDY_BACKUP_/myLocalAddress:12345");
        AssertJUnit.assertEquals((Object)expected, (Object)newPutCall.getFqn());
    }

    public void testMultiFqnManipulation() {
        Fqn fqn1 = Fqn.ROOT;
        Fqn fqn2 = Fqn.fromString((String)"/hello/world");
        Fqn fqn3 = Fqn.fromString((String)"/hello/again");
        Fqn fqn4 = Fqn.fromString((String)"/buddy/replication");
        PutKeyValueCommand call1 = new PutKeyValueCommand(null, fqn1, (Object)"key", (Object)"value");
        PutKeyValueCommand call2 = new PutKeyValueCommand(null, fqn2, (Object)"key", (Object)"value");
        PutKeyValueCommand call3 = new PutKeyValueCommand(null, fqn3, (Object)"key", (Object)"value");
        PutKeyValueCommand call4 = new PutKeyValueCommand(null, fqn4, (Object)"key", (Object)"value");
        ArrayList<PutKeyValueCommand> list = new ArrayList<PutKeyValueCommand>();
        list.add(call1);
        list.add(call2);
        list.add(call3);
        list.add(call4);
        ReplicateCommand call5 = new ReplicateCommand(list);
        BuddyManager bm = this.createBasicBuddyManager();
        ReplicateCommand newReplicatedCall = bm.transformReplicateCommand(call5);
        List l = newReplicatedCall.getModifications();
        String expected = "/_BUDDY_BACKUP_/myLocalAddress:12345";
        int i = 0;
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)expected), (Object)((PutKeyValueCommand)l.get(i++)).getFqn());
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)(expected + "/hello/world")), (Object)((PutKeyValueCommand)l.get(i++)).getFqn());
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)(expected + "/hello/again")), (Object)((PutKeyValueCommand)l.get(i++)).getFqn());
        AssertJUnit.assertEquals((Object)Fqn.fromString((String)(expected + "/buddy/replication")), (Object)((PutKeyValueCommand)l.get(i)).getFqn());
    }

    public void testGetActualFqn() {
        this.fqnTransformer = new BuddyFqnTransformer();
        Fqn x = Fqn.fromString((String)"/x");
        Fqn backup = this.fqnTransformer.getBackupFqn("y", x);
        AssertJUnit.assertEquals((Object)x, (Object)this.fqnTransformer.getActualFqn(backup));
    }
}

