/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BuddyPoolBroadcastTest
extends BuddyReplicationTestsBase {
    private Log log = LogFactory.getLog(BuddyPoolBroadcastTest.class);

    private void checkConsistentPoolState(List<CacheSPI<Object, Object>> caches) {
        for (int i = 0; i < caches.size(); ++i) {
            Map groupMap = caches.get((int)i).getBuddyManager().buddyPool;
            for (int j = 0; j < caches.size(); ++j) {
                if (i == j) continue;
                Map groupMap2 = caches.get((int)j).getBuddyManager().buddyPool;
                for (CacheSPI<Object, Object> cache : caches) {
                    AssertJUnit.assertEquals((String)("Comparing contents of cache " + (i + 1) + " pool map with cache " + (j + 1)), groupMap.get(cache), groupMap2.get(cache));
                }
            }
        }
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        long st = System.currentTimeMillis();
        super.tearDown();
        System.out.println("Teardown: " + (System.currentTimeMillis() - st));
    }

    public void test2CachesWithPoolNames() throws Exception {
        this.log.error((Object)"Running test2CachesWithPoolNames");
        this.caches = this.createCaches(2, true);
        this.log.error((Object)"Created 2 caches");
        BuddyManager m = ((CacheSPI)this.caches.get(0)).getBuddyManager();
        Map groupMap = m.buddyPool;
        AssertJUnit.assertEquals((Object)"A", groupMap.get(((CacheSPI)this.caches.get(0)).getLocalAddress()));
        AssertJUnit.assertEquals((Object)"B", groupMap.get(((CacheSPI)this.caches.get(1)).getLocalAddress()));
    }

    public void test3CachesWithPoolNames() throws Exception {
        this.log.debug((Object)"Running test3CachesWithPoolNames");
        long st = System.currentTimeMillis();
        this.caches = this.createCaches(3, true);
        System.out.println("Setup: " + (System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        BuddyManager m = ((CacheSPI)this.caches.get(0)).getBuddyManager();
        Map groupMap = m.buddyPool;
        AssertJUnit.assertEquals((Object)"A", groupMap.get(((CacheSPI)this.caches.get(0)).getLocalAddress()));
        AssertJUnit.assertEquals((Object)"B", groupMap.get(((CacheSPI)this.caches.get(1)).getLocalAddress()));
        AssertJUnit.assertEquals((Object)"C", groupMap.get(((CacheSPI)this.caches.get(2)).getLocalAddress()));
        System.out.println("Test: " + (System.currentTimeMillis() - st));
    }

    public void testBuddyPoolSync() throws Exception {
        this.log.debug((Object)"Running testBuddyPoolSync");
        this.caches = this.createCaches(3, true);
        Map map = ((CacheSPI)this.caches.get((int)0)).getBuddyManager().buddyPool;
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"A", map.get(((CacheSPI)this.caches.get(0)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"B", map.get(((CacheSPI)this.caches.get(1)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"C", map.get(((CacheSPI)this.caches.get(2)).getLocalAddress()));
        this.checkConsistentPoolState(this.caches);
    }

    public void testChangingBuddyPoolMembership() throws Exception {
        this.log.debug((Object)"Running testChangingBuddyPoolMembership");
        this.caches = this.createCaches(3, true);
        Map map = ((CacheSPI)this.caches.get((int)0)).getBuddyManager().buddyPool;
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"A", map.get(((CacheSPI)this.caches.get(0)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"B", map.get(((CacheSPI)this.caches.get(1)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"C", map.get(((CacheSPI)this.caches.get(2)).getLocalAddress()));
        this.checkConsistentPoolState(this.caches);
        ((CacheSPI)this.caches.get(1)).stop();
        this.caches.set(1, this.createCache(1, "Z"));
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"A", map.get(((CacheSPI)this.caches.get(0)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"Z", map.get(((CacheSPI)this.caches.get(1)).getLocalAddress()));
        AssertJUnit.assertEquals((String)"Failed on cache 1", (Object)"C", map.get(((CacheSPI)this.caches.get(2)).getLocalAddress()));
        this.checkConsistentPoolState(this.caches);
    }

    public void testConcurrency() throws Exception {
        this.log.debug((Object)"Running testConcurrency");
        int numCaches = 4;
        this.caches = new ArrayList(4);
        CountDownLatch latch = new CountDownLatch(1);
        CacheStarter[] starters = new CacheStarter[numCaches];
        for (int i = 0; i < numCaches; ++i) {
            this.caches.add(this.createCache(1, new String(new char[]{(char)(65 + i)}), false, false));
            starters[i] = new CacheStarter("CacheStarter-" + i, latch, (CacheSPI)this.caches.get(i));
            starters[i].start();
        }
        latch.countDown();
        TestingUtil.blockUntilViewsReceived(this.caches.toArray(new CacheSPI[0]), 240000L);
        TestingUtil.sleepThread(1000 * numCaches);
        Map map = ((CacheSPI)this.caches.get((int)0)).getBuddyManager().buddyPool;
        System.out.println(map);
        for (int i = 0; i < numCaches; ++i) {
            if (this.caches.get(i) != null) {
                AssertJUnit.assertEquals((String)("Failed on cache " + i + "(" + ((CacheSPI)this.caches.get(i)).getLocalAddress() + ")"), (Object)new String(new char[]{(char)(65 + i)}), map.get(((CacheSPI)this.caches.get(i)).getLocalAddress()));
                continue;
            }
            System.out.println("Cache " + i + " is null!??");
        }
        this.checkConsistentPoolState(this.caches);
    }

    public class CacheStarter
    extends Thread {
        private CountDownLatch latch;
        private CacheSPI cache;

        public CacheStarter(String name, CountDownLatch latch, CacheSPI cache) {
            super(name);
            this.latch = latch;
            this.cache = cache;
        }

        public void run() {
            try {
                this.latch.await();
                this.cache.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

