/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class BuddyReplicationWithTransactionsTest
extends BuddyReplicationTestsBase {
    private Fqn fqn = Fqn.fromString((String)"test");
    private String key = "key";
    private String value = "value";
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testTransactionsCommit() throws Exception {
        this.caches = this.createCaches(3, false, true, false);
        ((CacheSPI)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(((CacheSPI)this.caches.get(0)).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(((CacheSPI)this.caches.get(2)).getLocalAddress()) + "/test"));
        TestingUtil.dumpCacheContents(this.caches);
        TransactionManager txman = ((CacheSPI)this.caches.get(2)).getTransactionManager();
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        TestingUtil.dumpCacheContents(this.caches);
        ((CacheSPI)this.caches.get(2)).get(this.fqn, (Object)this.key);
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.commit();
        this.cleanupDelay();
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(newBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        TestingUtil.dumpCacheContents(this.caches);
        this.assertNoLocks(this.caches);
    }

    private void cleanupDelay() {
        TestingUtil.sleepThread(250L);
    }

    public void testTransactionsRollback() throws Exception {
        this.caches = this.createCaches(3, false, true, false);
        ((CacheSPI)this.caches.get(0)).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(((CacheSPI)this.caches.get(0)).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(((CacheSPI)this.caches.get(2)).getLocalAddress()) + "/test"));
        TestingUtil.dumpCacheContents(this.caches);
        TransactionManager txman = ((CacheSPI)this.caches.get(2)).getTransactionManager();
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        TestingUtil.dumpCacheContents(this.caches);
        ((CacheSPI)this.caches.get(2)).get(this.fqn, (Object)this.key);
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(2)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.rollback();
        TestingUtil.dumpCacheContents(this.caches);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(0)).exists(this.fqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)((CacheSPI)this.caches.get(1)).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(0)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(1)).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!((CacheSPI)this.caches.get(2)).exists(newBackupFqn) ? 1 : 0) != 0);
        this.assertNoLocks(this.caches);
    }
}

