/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.cluster;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationQueueNotifier;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class ReplicationQueueTxTest {
    Cache cache;
    Cache cache2;
    TransactionManager txManager;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.cache = new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC), false);
        this.cache.getConfiguration().setUseReplQueue(true);
        this.cache.getConfiguration().setReplQueueInterval(100L);
        this.cache.getConfiguration().setReplQueueMaxElements(10);
        this.cache.start();
        this.cache2 = new DefaultCacheFactory().createCache(this.cache.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, this.cache, this.cache2);
        this.txManager = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache, this.cache2);
    }

    public void testTransactionalReplication() throws Exception {
        this.cache.put("/a", (Object)"k", (Object)"v");
        ReplicationQueueNotifier replicationQueueNotifier = new ReplicationQueueNotifier(this.cache);
        replicationQueueNotifier.waitUntillAllReplicated(200L);
        assert (this.cache2.get("/a", (Object)"k").equals("v"));
        this.txManager.begin();
        this.cache2.put("/a", (Object)"k", (Object)"v2");
        this.txManager.commit();
        ReplicationQueueNotifier replicationQueueNotifier2 = new ReplicationQueueNotifier(this.cache2);
        replicationQueueNotifier2.waitUntillAllReplicated(200L);
        assert (this.cache.get("/a", (Object)"k").equals("v2"));
    }
}

