/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Set;
import org.easymock.EasyMock;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.mock.NodeSpiMock;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class GetKeysCommandTest
extends AbstractDataCommandTest {
    GetKeysCommand command;

    protected void moreSetup() {
        this.command = new GetKeysCommand(this.testFqn);
        this.command.initialize(this.container);
    }

    public void testForNonexistentNode() {
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.container});
        assert (null == this.command.perform(null));
    }

    public void testForExistingNode() {
        NodeSpiMock node = new NodeSpiMock(this.testFqn);
        node.putDirect("k1", "v1");
        node.putDirect("k2", "v2");
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{this.container});
        Set result = (Set)this.command.perform(null);
        assert (2 == result.size());
        assert (result.contains("k1"));
        assert (result.contains("k2"));
    }
}

