/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ConcurrentEvictionTest {
    private Cache<Integer, String> cache_;
    private int wakeupIntervalMillis_ = 0;
    private String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
    private String cacheLoaderDir = "/JBossCacheFileCacheLoader";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    void initCaches() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        DefaultCacheFactory factory = new DefaultCacheFactory();
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        conf.setEvictionConfig(this.buildEvictionConfig());
        conf.setCacheLoaderConfig(this.buildCacheLoaderConfig());
        conf.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache_ = factory.createCache(conf, true);
    }

    private CacheLoaderConfig buildCacheLoaderConfig() throws IOException {
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.setPassivation(false);
        cacheLoaderConfig.setPreload("/");
        cacheLoaderConfig.setShared(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName("org.jboss.cache.loader.FileCacheLoader");
        Properties p = new Properties();
        p.put("location", this.tmpDir + this.cacheLoaderDir);
        iclc.setProperties(p);
        iclc.setAsync(false);
        iclc.setFetchPersistentState(true);
        iclc.setIgnoreModifications(false);
        cacheLoaderConfig.addIndividualCacheLoaderConfig(iclc);
        return cacheLoaderConfig;
    }

    private EvictionConfig buildEvictionConfig() {
        EvictionConfig ec = new EvictionConfig("org.jboss.cache.eviction.LRUPolicy");
        ec.setDefaultEvictionPolicyClass("org.jboss.cache.eviction.LRUPolicy");
        ec.setWakeupIntervalSeconds(5);
        EvictionRegionConfig erc = UnitTestCacheConfigurationFactory.buildLruEvictionRegionConfig("_default_", 5000, 1000);
        ArrayList<EvictionRegionConfig> erConfigs = new ArrayList<EvictionRegionConfig>();
        erConfigs.add(erc);
        ec.setEvictionRegionConfigs(erConfigs);
        return ec;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.recursiveFileRemove(this.tmpDir + this.cacheLoaderDir);
        this.cache_.stop();
        this.cache_ = null;
    }

    public void testConcurrentEviction() throws Exception {
        Fqn base = Fqn.fromString((String)"/org/jboss/test/data/concurrent/eviction");
        for (int i = 0; i < 1000; ++i) {
            this.cache_.put(Fqn.fromRelativeElements((Fqn)base, (Object[])new Object[]{i / 100}), (Object)i, (Object)"value");
        }
        long loopDone = System.currentTimeMillis() + (long)(5 * this.wakeupIntervalMillis_);
        while (System.currentTimeMillis() < loopDone) {
            for (int i = 0; i < 1000; ++i) {
                Fqn fqn = Fqn.fromRelativeElements((Fqn)base, (Object[])new Object[]{i / 100});
                Integer key = i;
                AssertJUnit.assertNotNull((String)("found value under Fqn " + fqn + " and key " + key), (Object)this.cache_.get(fqn, (Object)key));
            }
        }
    }
}

