/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LRUPolicyTest {
    CacheSPI<Object, Object> cache;
    int wakeupIntervalMillis_ = 0;
    int dataRegionTTLMillis = 6000;
    int testRegionTTLMillis = 4000;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = conf.getEvictionConfig();
        evConfig.setWakeupIntervalSeconds(1);
        ArrayList<EvictionRegionConfig> regionConfigs = new ArrayList<EvictionRegionConfig>();
        regionConfigs.add(UnitTestCacheConfigurationFactory.buildLruEvictionRegionConfig("/org/jboss/test/data", 5, this.dataRegionTTLMillis / 1000));
        regionConfigs.add(UnitTestCacheConfigurationFactory.buildLruEvictionRegionConfig("/test", 10000, this.testRegionTTLMillis / 1000));
        evConfig.setEvictionRegionConfigs(regionConfigs);
        conf.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        conf.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(conf);
        this.wakeupIntervalMillis_ = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        System.out.println("-- wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    public void testInUseEviction() throws Exception {
        Fqn f;
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/test/data/inuse/";
        for (i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        System.out.println("-- Marking as in-use");
        this.cache.getRegionManager().getRegion(Fqn.fromString((String)(rootStr + 5)), false).markNodeCurrentlyInUse(Fqn.fromString((String)(rootStr + 5)), 0L);
        for (i = 10; i < 15; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        for (i = 0; i < 5; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null == this.cache.getNode(f)) : f + " should be null";
        }
        AssertJUnit.assertNotNull((Object)this.cache.getNode(Fqn.fromString((String)(rootStr + 5))));
        for (i = 6; i < 11; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null == this.cache.getNode(f)) : f + " should be null";
        }
        for (i = 11; i < 15; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null != this.cache.getNode(f)) : f + " should not be null";
        }
    }

    public void testEviction() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache.toString());
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        System.out.println(this.cache.toString());
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testNodeVisited() {
        Fqn fqn;
        String str;
        String rootStr = "/org/jboss/test/data/";
        System.out.println("REGIONS: " + this.cache.getRegionManager().dumpRegions());
        for (int i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        int period = this.wakeupIntervalMillis_ / 2 + 500;
        System.out.println("-- sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        str = rootStr + "7";
        fqn = Fqn.fromString((String)str);
        this.cache.get(fqn, (Object)str);
        System.out.println("-- sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        this.cache.get(fqn, (Object)str);
        System.out.println("-- sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        System.out.println("-- val=" + val);
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
        val = (String)this.cache.get(rootStr + "7", (Object)(rootStr + "7"));
        System.out.println("-- val=" + val);
        AssertJUnit.assertNotNull((String)"Node should not be empty ", (Object)val);
        period = this.dataRegionTTLMillis + this.wakeupIntervalMillis_ + 500;
        System.out.println("-- sleeping for " + period + "ms");
        TestingUtil.sleepThread(period);
        val = (String)this.cache.get(rootStr + "7", (Object)(rootStr + "7"));
        System.out.println("-- val=" + val);
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testNodeRemoved() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i + "/" + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        int period = this.wakeupIntervalMillis_ / 2 + 500;
        System.out.println("-- period is " + period);
        String str1 = rootStr + "7";
        Fqn fqn1 = Fqn.fromString((String)str1);
        String str2 = rootStr + "7/7";
        Fqn fqn2 = Fqn.fromString((String)str2);
        this.cache.get(fqn1, (Object)str1);
        this.cache.get(fqn2, (Object)str2);
        TestingUtil.sleepThread(period);
        this.cache.get(fqn1, (Object)str1);
        this.cache.get(fqn2, (Object)str2);
        TestingUtil.sleepThread(period);
        String val = (String)this.cache.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
        AssertJUnit.assertNotNull((String)"Node should not be empty ", (Object)val);
        this.cache.removeNode(fqn1);
        TestingUtil.sleepThread(this.wakeupIntervalMillis_ + 500);
        val = (String)this.cache.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testCompleteRemoval() throws Exception {
        String rootStr = "/test/";
        Fqn parent = Fqn.fromString((String)(rootStr + "parent"));
        this.cache.put(parent, (Object)"key", (Object)"value");
        this.cache.put(Fqn.fromRelativeElements((Fqn)parent, (Object[])new Object[]{"child"}), (Object)"key", (Object)"value");
        int period = (this.wakeupIntervalMillis_ + this.testRegionTTLMillis) * 2;
        System.out.println("-- Sleeping for " + period);
        TestingUtil.sleepThread(period);
        AssertJUnit.assertFalse((String)"Parent not completely removed", (boolean)this.cache.getRoot().hasChild(parent));
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.create();
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            System.out.println("-- nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    public void testForEvictionInternalError() {
        String rootStr = "/test/testdata";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(2 * (this.wakeupIntervalMillis_ + this.testRegionTTLMillis));
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        this.cache.removeNode(Fqn.ROOT);
        TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 1000);
        val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testOvereviction() throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        Cache cache1 = new DefaultCacheFactory().createCache(c, true);
        cache1.put(Fqn.fromString((String)"/base/0"), (Object)"key", (Object)"base0");
        Node node = cache1.getRoot().getChild(Fqn.fromString((String)"/base/"));
        node.setResident(true);
        for (int i = 1; i < 5100; ++i) {
            cache1.put(Fqn.fromString((String)("/base/" + i)), (Object)"key", (Object)("base" + i));
        }
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((int)5000, (int)cache1.getRoot().getChild(Fqn.fromString((String)"/base")).getChildren().size());
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (LRUPolicyTest.this.isTrue) {
                try {
                    LRUPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (IllegalStateException ise) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (LRUPolicyTest.this.t1_ex != null) continue;
                    LRUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

