/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MRUPolicyTest {
    CacheSPI<Object, Object> cache;
    int wakeupIntervalMillis = 0;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    private void initCaches() {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = config.getEvictionConfig();
        evConfig.setWakeupIntervalSeconds(3);
        evConfig.setDefaultEventQueueSize(200000);
        evConfig.setDefaultEvictionPolicyClass("org.jboss.cache.eviction.MRUPolicy");
        ArrayList<EvictionRegionConfig> evictionRegionConfigs = new ArrayList<EvictionRegionConfig>();
        evictionRegionConfigs.add(this.buildEvictionRegionConfig("_default_", 100));
        evictionRegionConfigs.add(this.buildEvictionRegionConfig("/org/jboss/test/data", 6));
        evConfig.setEvictionRegionConfigs(evictionRegionConfigs);
        config.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(config);
    }

    private EvictionRegionConfig buildEvictionRegionConfig(String regionName, int maxNodes) {
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionName(regionName);
        MRUConfiguration mruConfiguration = new MRUConfiguration();
        mruConfiguration.setMaxNodes(maxNodes);
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)mruConfiguration);
        return erc;
    }

    public void testEviction() throws Exception {
        this.cache.put("/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a");
        this.cache.put("/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b");
        this.cache.put("/org/jboss/test/data/c", (Object)"/org/jboss/test/data/c", (Object)"/org/jboss/test/data/c");
        this.cache.put("/org/jboss/test/data/d", (Object)"/org/jboss/test/data/d", (Object)"/org/jboss/test/data/d");
        this.cache.put("/org/jboss/test/data/e", (Object)"/org/jboss/test/data/e", (Object)"/org/jboss/test/data/e");
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        this.cache.put("/org/jboss/test/data/f", (Object)"/org/jboss/test/data/f", (Object)"/org/jboss/test/data/f");
        this.cache.put("/org/jboss/test/data/g", (Object)"/org/jboss/test/data/g", (Object)"/org/jboss/test/data/g");
        this.cache.put("/org/jboss/test/data/h", (Object)"/org/jboss/test/data/h", (Object)"/org/jboss/test/data/h");
        AssertJUnit.assertNotNull((Object)this.cache.get("/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b"));
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        AssertJUnit.assertNull((Object)this.cache.get("/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a"));
        AssertJUnit.assertNull((Object)this.cache.get("/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b"));
    }

    public void testNodeRemoved() throws Exception {
        this.cache.put("/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a", (Object)"/org/jboss/test/data/a");
        this.cache.put("/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b", (Object)"/org/jboss/test/data/b");
        this.cache.put("/org/jboss/test/data/c", (Object)"/org/jboss/test/data/c", (Object)"/org/jboss/test/data/c");
        this.cache.put("/org/jboss/test/data/d", (Object)"/org/jboss/test/data/d", (Object)"/org/jboss/test/data/d");
        this.cache.put("/org/jboss/test/data/e", (Object)"/org/jboss/test/data/e", (Object)"/org/jboss/test/data/e");
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        this.cache.removeNode("/org/jboss/test/data/d");
        this.cache.removeNode("/org/jboss/test/data/e");
        this.cache.put("/org/jboss/test/data/f", (Object)"/org/jboss/test/data/f", (Object)"/org/jboss/test/data/f");
        this.cache.put("/org/jboss/test/data/g", (Object)"/org/jboss/test/data/g", (Object)"/org/jboss/test/data/g");
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500);
        AssertJUnit.assertNull((Object)this.cache.get("/org/jboss/test/data/d", (Object)"/org/jboss/test/data/d"));
        AssertJUnit.assertNull((Object)this.cache.get("/org/jboss/test/data/e", (Object)"/org/jboss/test/data/e"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/org/jboss/test/data/f", (Object)"/org/jboss/test/data/f"));
        AssertJUnit.assertNotNull((Object)this.cache.get("/org/jboss/test/data/g", (Object)"/org/jboss/test/data/g"));
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 10);
        this.isTrue = false;
    }

    private void log(String s) {
        System.out.println(s);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (MRUPolicyTest.this.isTrue) {
                try {
                    MRUPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    TestingUtil.sleepThread(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (MRUPolicyTest.this.t1_ex != null) continue;
                    MRUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

